/**
 * Copyright selflash ( http://wonderfl.net/user/selflash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uaKO
 */

/*
 *
 * @author selflash
 * @version 1.0.0
 * @date    2010/03/06
 * @see     http://selflash.jp/
 * 
 * DisplayObject3Dでマスクのかけ方の練習
 * 注意:3つも表示させて処理が重いのかPCがすぐ高温になります！
 * 
 * Because the personal computer becomes high temperature, please note
 *
 * 追記：なんか高温になるの僕のPCだけかも、、、
 */
package {
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.filters.*;
    
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    
    [SWF(width = "440", height = "440", frameRate = "60", backgroundColor = "#FFFFFF")]

    public class FlashTest extends BasicView {
        private var cube1:Cube;
        private var cube2:Cube;
        private var cube3:Cube;
        private var maskObj:Sphere;
        
        private const WIRE_MAT:WireframeMaterial = new WireframeMaterial( 0x000000 );       
        private const COLOR_MAT:ColorMaterial = new ColorMaterial(0xFFFFFF * Math.random(), 1); 
        private const FACE_NAME:Array = ["front", "back", "top", "bottom", "right", "left"];
             
        public function FlashTest():void {            
            scene.addChild(createFloor());
            
            cube1 = createCube(true);
            cube1.x = -100;
            scene.addChild(cube1);
            
            maskObj = new Sphere(COLOR_MAT, 80, 16, 16);
            maskObj.x = -110;    
            maskObj.y = 30;        
            scene.addChild(maskObj);           
            
            var layer1:ViewportLayer = viewport.getChildLayer(cube1);
            var maskLayer1:ViewportLayer = viewport.getChildLayer(maskObj);
            layer1.mask = maskLayer1;
            
            layer1.filters = [new GlowFilter( 0x000000, 1, 16, 16, 6 )];  
       
            cube2 = createCube(true);
            cube2.x = 100;
            scene.addChild(cube2);
            
            maskObj = new Sphere(COLOR_MAT, 80, 16, 16);
            maskObj.x = 110;    
            maskObj.y = 30;        
            scene.addChild(maskObj);           
            
            var layer2:ViewportLayer = viewport.getChildLayer(cube2);
            var maskLayer2:ViewportLayer = viewport.getChildLayer(maskObj);
            layer2.mask = maskLayer2;
            
            layer2.filters = [new GlowFilter( 0xFF3322, 1, 18, 18 )];  
            layer2.blendMode = BlendMode.INVERT; 
            
            //viewport.containerSprite.blendMode = BlendMode.INVERT; 
            
            cube3 = createCube(false);
            cube3.y = 200;
            scene.addChild(cube3);
            
            maskObj = new Sphere(COLOR_MAT, 80, 16, 16);
            maskObj.x = 10; 
            maskObj.y = 230;           
            scene.addChild(maskObj);           
            
            var layer3:ViewportLayer = viewport.getChildLayer(cube3);
            var maskLayer3:ViewportLayer = viewport.getChildLayer(maskObj);
            layer3.mask = maskLayer3;
            
            layer3.filters = [new GlowFilter( 0xFF3322, 1, 18, 18 )];  
            layer3.blendMode = BlendMode.INVERT;  
            
            startRendering();
        }
        
	private function createFloor():Plane {
            var plane:Plane = new Plane(WIRE_MAT, 600, 600, 10, 10);
	    plane.rotationX = 90;
            plane.rotationY = 20;
	    plane.y = -100;
	    
            return plane;
	}

	private function createCube(color:Boolean):Cube {
	    var matList:MaterialsList = new MaterialsList(); 
            for (var i:int = 0; i < FACE_NAME.length; i++ ) {
                 var material:CompositeMaterial = new CompositeMaterial();
                 material.addMaterial( WIRE_MAT );
                 if(color)material.addMaterial( COLOR_MAT );
                 
                 matList.addMaterial(material, FACE_NAME[i]);
	    }
	    
            return new Cube(matList, 120, 120, 120, 1, 1, 1);
	}

	override protected function onRenderTick(e:Event = null):void {
            super.onRenderTick();               
            
            cube1.rotationX = cube3.rotationX += Math.sin(getTimer() / 1000);
            cube2.rotationX = cube1.rotationY += Math.sin(getTimer() / 2000);
            cube3.rotationY = cube2.rotationY += Math.sin(getTimer() / 3000);
            
            //maskObj.rotationX = -mouseY;
            //maskObj.rotationY = -mouseX;
            
            camera.x = 500 * Math.sin(getTimer() / 3400);
            camera.y = 100 * Math.sin(getTimer() / 2000) + 100;
	    camera.z = 200 * Math.cos(getTimer() / 2000);
	}
    }
}
