/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uZp3
 */

//PC漁ってたら出てきた物
package 
{
    import Box2D.Dynamics.b2Body;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickContacts;
    import com.actionsnippet.qbox.QuickObject;
    import com.bit101.components.Label;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(backgroundColor="0xFFFFFF", width=465, height=465, frameRate=60)]
    public class Main extends MovieClip 
    {
        private var _qbox:QuickBox2D;
        private var _circles:Array;
        private var _contacts:QuickContacts;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.quality = StageQuality.LOW;
            
            new Label(this, 30, 25, "CLICK STAGE");
            
            _qbox = new QuickBox2D(this);
            _qbox.createStageWalls();
            _qbox.mouseDrag();
            _qbox.start();
            
            _circles = [];
            for (var i:int = 0; i < 15; i++) 
            {
                _circles.push(_qbox.addCircle( { x:Math.random() * 15.5, y:Math.random() * 15.5, radius:(Math.random()+0.01)/2 } ));
            }
            
            _contacts = _qbox.addContactListener();
            _contacts.addEventListener(QuickContacts.ADD, _onAdd);
            
            stage.addEventListener(MouseEvent.CLICK, _onClick);
        }
        
        private function _onClick(e:MouseEvent):void 
        {
            _circles.push(_qbox.addCircle( { x:mouseX / 30, y:mouseY / 30, radius:(Math.random()+0.01)/2 } ));
        }
        
        private function _onAdd(e:Event):void 
        {
            var l:Number = _circles.length;
            for (var i:int = 0; i < l; i++)
            {
                var circA:QuickObject = _circles[i];
                if (circA.body.GetJointList() != null) continue;
                for (var j:int = 0; j < l; j++)
                {
                    var circB:QuickObject = _circles[j];
                    
                    if (_contacts.isCurrentContact(circA, circB))
                    {
                        _qbox.addJoint( { a:circA.body, b:circB.body } );
                    }
                    
                    /*var a:b2Body = circA.body.GetJointList().joint.GetBody1();
                    var b:b2Body = circB.body.GetJointList().joint.GetBody1();
                    if (a != circA.body && a != circB.body &&
                        b != circA.body && b != circB.body &&
                        _contacts.isCurrentContact(circA, circB))
                    {
                        _qbox.addJoint( { type:QuickBox2D.PRISMATIC, a:circA.body, b:circB.body } );
                    }*/
                }
            }
        }
        
    }
    
}