/**
 * Copyright bcosizm ( http://wonderfl.net/user/bcosizm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uZit
 */

package {
	//20100308 made by B.cos
	//紙飛行機飛ばしてみる～
	
	import flash.events.*;
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
    
    public class FlashTest extends BasicView {   		
    		private var obj_earth:Sphere;//球形インスタンス
    		private var obj_plane:PaperPlane;//紙飛行機インスタンス
    		
    		private var rotx:Number = 0;
    		private var roty:Number = 0; 
    		
    		private var rot:Number=0;
    		
    		public function FlashTest() {
    			//惑星作成
            //混合マテリアル作成
            var material:CompositeMaterial = new CompositeMaterial();
            material.addMaterial(new ColorMaterial(0x222222,0.8));
            material.addMaterial(new WireframeMaterial(0x00FF00)); 
            //球形作成
            obj_earth = new Sphere(material,400,50,15);
            
            //3D空間に球体を追加
            scene.addChild(obj_earth);
            
            //紙飛行機作成
            //混合マテリアル作成
            var material_plane:CompositeMaterial = new CompositeMaterial();
            material_plane.addMaterial(new ColorMaterial(0x222222,0.4));
            material_plane.addMaterial(new WireframeMaterial(0xFF00)); 
            //飛行機作成
            obj_plane = new PaperPlane(material_plane,1);
            obj_earth.addChild(obj_plane);
            
            obj_plane.rotationX=90;
            obj_plane.rotationZ=-90;
            
            obj_plane.lookAt(DisplayObject3D.ZERO);
            
            camera.target=obj_plane;
            obj_plane.addChild(camera);
            
            //レンダリング開始
            startRendering();
            
            //エンターフレームのイベントを登録
            addEventListener(Event.ENTER_FRAME,loop);	
        }

        //アニメーション
        private function loop(e:Event):void
        {
       		//マウスのX座標がステージの幅の何%の位置にあるか調べてそれを360度で乗算する。
        		var targetRotX:Number = (mouseX/stage.stageWidth)*360;
        		var targetRotY:Number = (mouseY/stage.stageHeight)*360;
        		//イージングの公式を用いて滑らかにする。
        		//値 +=（目標値-現在値）*減速値
        		rotx += (targetRotX-rotx)*0.02;
        		roty += (targetRotY-roty)*0.02;
        		//角度に応じてカメラの位置を設定
        		//横方向
        		//camera.x = 1200*Math.sin(rotx*Math.PI/180);
        		//camera.z = 1200*Math.cos(rotx*Math.PI/180);
        		//縦方向
        		//camera.y = 2000*Math.sin(roty*Math.PI/180);
        		
        		//飛行機移動
        		rot -=1;
        		
        		//obj_plane.x = obj_earth.x+500;
        		obj_plane.x = 500*Math.sin(rot*Math.PI/180);
        		obj_plane.z = 500*Math.cos(rot*Math.PI/180);
        		camera.x=obj_plane.x;
        		camera.z=obj_plane.z-200;
        		camera.y=obj_plane.y-200;
        		
        }
    }
}