/**
 * Copyright webpqw ( http://wonderfl.net/user/webpqw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uZfE
 */

package
{
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.ui.Keyboard;
    import flash.utils.Timer;
    
    public class ClockSprite extends Sprite
    {
        var total:Number = 24;
        var radius:Number = 500;
        var hour:Number;
        var minu:Number;
        var sec:Number;
        var shrink_rate:Number = 0.2;
        var max_shrink_rate:Number = 0.2;
        var min_shrink_rate:Number = shrink_rate
        var max_speed:Number = 0.5;
        var center_pos:Point ;
        var zn:Number=0.8
        var wind_dx:Number = 0;
        var wind_dy:Number = 0;
        var wind_max:Number = 0.00005;
        var wind_ddx:Number = (Math.random()-0.5)*wind_max;
        var wind_ddy:Number = (Math.random()-0.5)*wind_max;
        var time_val:Timer = new Timer(1000);
        var keyPoll:KeyPoll
        var h_level:Sprite
        public function ClockSprite()
        {
            super();
            h_level = this.addChild(new Sprite) as Sprite;
            
            
            time_val.addEventListener(TimerEvent.TIMER,onTimer);
            
            this.addEventListener(Event.ADDED_TO_STAGE,addStage);
        }
        private function addStage(e:Event):void{
            keyPoll = new KeyPoll(stage);
            center_pos = new Point(960/2+random(100)-50, 560/2+random(100)-50);
            initSoap(total);
            onTimer();
            time_val.start();
            this.addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void{
            center_pos = getCenter(total);
            shrink(total, shrink_rate);
            draw();
            
        }
        function random(num:Number):int{
            return int(Math.random()*num);
        }
        function dotEnterFrame(e:Event):void{
            var dot:MovieClip = e.currentTarget as MovieClip;
            dot.pos = new Point(dot.x, dot.y);
            if(keyPoll.isDown(Keyboard.SPACE)){
                dot.lock=true
                dot.lock_mc.gotoAndStop(2)
            }
        }
        function dotPress(e:MouseEvent):void{
            var dot:MovieClip = e.currentTarget as MovieClip;
            dot.startDrag(false);
            dot.drag = true;
            dot.lock=false
            dot.lock_mc.gotoAndStop(1)
            shrink_rate = max_shrink_rate;
            dot.addEventListener(Event.ENTER_FRAME,dotEnterFrame);
        }
        function dotRelease(e:MouseEvent):void{
            var dot:MovieClip = e.currentTarget as MovieClip;
            //trace("release")
            dot.stopDrag();
            if(!dot.lock){
            dot.drag = false;
            }
            shrink_rate = min_shrink_rate;
            dot.removeEventListener(Event.ENTER_FRAME,dotEnterFrame);
        }
        function initSoap(num:Number) {
            var dot_num:Number = num;
            while (dot_num-->0) {
                var dot:MovieClip = this.addChild(new Sprite()) as MovieClip;
                dot.name = "dot"+dot_num;
                dot.x = 50*Math.cos(dot_num/num*Math.PI*2-Math.PI*0.4)+center_pos.x+random(20)-10;
                dot.y = 50*Math.sin(dot_num/num*Math.PI*2-Math.PI*0.4)+center_pos.y+random(20)-10;
                dot.id = dot_num;
                dot.v=new Point(0,0)
                dot.pos = new Point(dot.x, dot.y);
                dot.useHandCursor = false;
                dot.cacheAsBitmap = true;
                dot.addEventListener(MouseEvent.MOUSE_DOWN,dotPress);
                dot.addEventListener(MouseEvent.MOUSE_UP,dotRelease);
            }
            
            for(var i=0;i<total/2;i++){
                var num_mc:MovieClip = this.addChild(new MovieClip()) as MovieClip;
                num_mc.name = "num"+i;
                //num_mc.gotoAndStop(i+1);
                //trace(num_mc)
                num_mc.cacheAsBitmap = true;
            }
            var dot_num:Number = num;
            while (dot_num-->0) {
                var dot:MovieClip = this.getChildByName("dot"+dot_num) as MovieClip;
                if (dot.id>0) {
                    dot.left = this.getChildByName("dot"+(dot.id-1)) as MovieClip;
                } else {
                    dot.left = null;
                }
                if (dot.id<num-1) {
                    dot.right = this.getChildByName("dot"+(dot.id+1)) as MovieClip;
                } else {
                    dot.right = null;
                }
                //trace(dot._name+"  left:"+dot.left+"  right:"+dot.right);
            }
            dot0 = evalByName("dot" + 0);
            dot0.left =  this.getChildByName("dot"+(num-1)) as MovieClip;
            MovieClip(this.getChildByName("dot"+(num-1))).right = dot0;
            //dot0.drag = true;
        }
        //收缩函数
        function shrink(num:Number, rate:Number) {
            var dot_num:Number = num;
            while (dot_num-->0) {
                var dot:MovieClip = MovieClip(this.getChildByName("dot"+dot_num));
                if (!dot.drag) {
                    var l:Point = dot.left.pos.subtract(dot.pos);
                    var r:Point = dot.right.pos.subtract(dot.pos);
                    var s:Point = dot.pos.subtract(center_pos);
                    s.normalize(radius/s.length);
                    dot.force = l.add(r).add(s);
                    dot.v.x += dot.force.x*rate+wind_dx
                    dot.v.y += dot.force.y*rate+wind_dy
                    dot.v.x*=zn
                    dot.v.y*=zn
                    dot.pos.x+=dot.v.x
                    dot.pos.y+=dot.v.y
                    if (dot.pos.x<20 || dot.pos.x>960-20) {
                        wind_dx *= -0.5;
                        dot.v.x*=-1
                        //wind_ddx*=-1    
                        //wind_ddx = (Math.random()-0.5)*wind_max;
                    }
                    if (dot.pos.y<20 || dot.pos.y>560-20) {
                        wind_dy *= -0.5;
                        dot.v.y*=-1
                        //wind_ddy*=-1
                        //wind_ddy = (Math.random()-0.5)*wind_max;
                    }
                    dot.pos.x = Math.min(dot.pos.x, 960-20);
                    dot.pos.x = Math.max(dot.pos.x, 20);
                    dot.pos.y = Math.min(dot.pos.y, 560-20);
                    dot.pos.y = Math.max(dot.pos.y, 20);
                    wind_dx += wind_ddx;
                    wind_dy += wind_ddy;
                    wind_ddx *= 0.9;
                    wind_ddy *= 0.9;
                    if (Math.abs(wind_ddx)<0.001) {
                        //wind_ddx = (Math.random()-0.5)*wind_max;
                    }
                    if (Math.abs(wind_ddy)<0.00001) {
                        //wind_ddy = (Math.random()-0.5)*wind_max;
                    }
                    //trace(dot.force)  
                }
            }
            var dot_num:Number = num;
            while (dot_num-->0) {
                var dot:MovieClip =MovieClip(this.getChildByName("dot"+dot_num));
                if (!dot.drag) {
                    //trace(dot.force)
                    dot.x = dot.pos.x;
                    dot.y = dot.pos.y;
                }
            }
        }
        function getCenter(num:Number):Point {
            var x_total:Number = 0;
            var y_total:Number = 0;
            var dot_num:Number = num;
            while (dot_num-->0) {
                x_total += MovieClip(this.getChildByName("dot"+dot_num)).pos.x;
                y_total += MovieClip(this.getChildByName("dot"+dot_num)).pos.y;
            }
            return new Point(x_total/num, y_total/num);
        }
        function evalByName(str:String):MovieClip{
            return MovieClip(this.getChildByName(str));
        }
        function draw() {
            graphics.clear();
            //表面
            graphics.beginFill(0xCFBB02, 100);
            var k = total-1;
            var insert_array:Array = new Array();
            var insert_pos:Point = new Point((dot0.x+evalByName("dot"+k).x)/2, (dot0.y+evalByName("dot"+k).y)/2);
            insert_array.push(insert_pos.clone());
            graphics.moveTo(insert_pos.x, insert_pos.y);
            for (var i = 1; i<total/2+1; i++) {
                var j = i-1;
                insert_pos = new Point((evalByName("dot"+i).x+evalByName("dot"+j).x)/2, (evalByName("dot"+i).y+evalByName("dot"+j).y)/2);
                insert_array.push(insert_pos.clone());
                graphics.curveTo(evalByName("dot"+j).x, evalByName("dot"+j).y, insert_pos.x, insert_pos.y);
            }
            graphics.lineTo(center_pos.x,center_pos.y)
            graphics.lineTo(insert_array[0].x, insert_array[0].y);
            graphics.endFill();
            graphics.beginFill(0xFDB102, 100);
            graphics.moveTo(insert_array[insert_array.length-1].x, insert_array[insert_array.length-1].y);
            for (var i = total/2+1; i<total; i++) {
                var j = i-1;
                insert_pos = new Point((evalByName("dot"+i).x+evalByName("dot"+j).x)/2, (evalByName("dot"+i).y+evalByName("dot"+j).y)/2);
                insert_array.push(insert_pos.clone());
                graphics.curveTo(evalByName("dot"+j).x, evalByName("dot"+j).y, insert_pos.x, insert_pos.y);
            }
            insert_pos = new Point((dot0.x+evalByName("dot"+k).x)/2, (dot0.y+evalByName("dot"+k).y)/2);
            insert_array.push(insert_pos.clone());
            graphics.curveTo(evalByName("dot"+k).x, evalByName("dot"+k).y, insert_pos.x, insert_pos.y);
            graphics.lineTo(center_pos.x,center_pos.y)
            //lineTo(insert_array[0].x, insert_array[0].y);
            graphics.endFill();
            //指示
            //center_pos = Point.interpolate(insert_array[0], insert_array[6], 0.5);
            graphics.lineStyle(4, 0xFFFFCC, 100, true, "normal", "none", "miter", 1);
            for (var i = 0; i<total; i+=2) {
                if (i%6) {
                    var d_pos:Point = Point.interpolate(insert_array[i], center_pos, 0.9);
                } else {
                    var d_pos:Point = Point.interpolate(insert_array[i], center_pos, 0.75);
                }
                graphics.moveTo(insert_array[i].x, insert_array[i].y);
                graphics.lineTo(d_pos.x, d_pos.y);
            }
            //外围
            graphics.lineStyle(5, 0x6D4D01, 100);
            var k = total-1;
            var insert_pos:Point = new Point((dot0.x+evalByName("dot"+k).x)/2, (dot0.y+evalByName("dot"+k).y)/2);
            graphics.moveTo(insert_pos.x, insert_pos.y);
            for (var i = 1; i<total; i++) {
                var j = i-1;
                insert_pos = new Point((evalByName("dot"+i).x+evalByName("dot"+j).x)/2, (evalByName("dot"+i).y+evalByName("dot"+j).y)/2);
                graphics.curveTo(evalByName("dot"+j).x, evalByName("dot"+j).y, insert_pos.x, insert_pos.y);
            }
            insert_pos = new Point((dot0.x+evalByName("dot"+k).x)/2, (dot0.y+evalByName("dot"+k).y)/2);
            graphics.curveTo(evalByName("dot"+k).x, evalByName("dot"+k).y, insert_pos.x, insert_pos.y);
            //数字
            for (var i = 0; i<total; i+=2) {
                var pos:Point = Point.interpolate(center_pos, insert_array[i], -0.15);
                evalByName("num"+int(i/2)).x = pos.x;
                evalByName("num"+int(i/2)).y = pos.y;
            }
            //hours
            h_level.graphics.clear();
            h_level.graphics.lineStyle(6, 0x6D4D01, 100, true, "normal", "square", "miter", 1);
            h_pos = Point.interpolate(insert_array[(hour+1)*2], insert_array[hour*2], minu/60);
            h_pos = Point.interpolate(center_pos, h_pos, 0.5);
            h_level.graphics.moveTo(center_pos.x, center_pos.y);
            h_level.graphics.lineTo(h_pos.x, h_pos.y);
            //minu
            h_level.graphics.lineStyle(4, 0x8F6401, 100, true, "normal", "square", "miter", 1);
            var mm:Number = Math.floor(minu/5);
            m_pos = Point.interpolate(insert_array[(mm+1)*2], insert_array[mm*2], (minu%5)/5);
            m_pos = Point.interpolate(center_pos, m_pos, 0.3);
            h_level.graphics.moveTo(center_pos.x, center_pos.y);
            h_level.graphics.lineTo(m_pos.x, m_pos.y);
            //sec
            h_level.graphics.lineStyle(2, 0xA07001, 100, true, "normal", "square", "miter", 1);
            jump_id = Math.floor(sec/5);
            s_pos = Point.interpolate(insert_array[(jump_id+1)*2], insert_array[(jump_id)*2], (sec%5)/5);
            s_pos = Point.interpolate(center_pos, s_pos, 0.2);
            s_e_pos = Point.interpolate(center_pos, s_pos, 1.2);
            s_m_pos = Point.interpolate(s_pos, center_pos, 0.6);
            s_m_pos.y += dm*Math.sin(dmr);
            s_m_pos.x += dm*Math.cos(dmr);
            dmr += 0.5;
            dm *= 0.95;
            h_level.graphics.moveTo(s_e_pos.x, s_e_pos.y);
            h_level.graphics.curveTo(s_m_pos.x, s_m_pos.y, s_pos.x, s_pos.y);
            //
            if(it && !it.lock){
            it.pos.x += dx;
            it.pos.y += dy;
            }
        }
        function onTimer(e:Event=null):void {
            var time:Date = new Date();
            hour = time.getHours()%12;
            minu = time.getMinutes();
            sec = time.getSeconds();
            if (!(random(3))) {
                it = evalByName("dot"+random(total));
                dx = (Math.random()-0.5)*max_speed;
                dy = (Math.random()-0.5)*max_speed;
                wind_dx = dx/2;
                wind_dy = dy/2;
                wind_ddx = (Math.random()-0.5)*wind_max;
                wind_ddx = (Math.random()-0.5)*wind_max;
            }
            if (!(random(5))) {
                radius = 200+random(500);
            }
            dm = random(10)+10;
            dmr = -1;
            //evalByName("dot"+random(total)).pos.y+=random(20)-10
            //evalByName("dot"+jump_id).pos = evalByName("dot"+jump_id).right.pos.clone();
            //evalByName("dot"+jump_id).left.pos = evalByName("dot"+jump_id).left.left.pos.clone();
            //trace("now time is "+hour+":"+minu+":"+sec);
        }
        var h_pos:Point;
        var m_pos:Point;
        var s_pos:Point;
        var s_e_pos:Point;
        var s_m_pos:Point;
        var dmr:Number;
        var dm:Number;
        var jump_id:int
        var it:MovieClip;
        var dx:Number
        var dy:Number
        var dot0:MovieClip
    }
}

import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.DisplayObject;
    import flash.utils.ByteArray;
    
    /**
     * <p>Games often need to get the current state of various keys in order to respond to user input. 
     * This is not the same as responding to key down and key up events, but is rather a case of discovering 
     * if a particular key is currently pressed.</p>
     * 
     * <p>In Actionscript 2 this was a simple matter of calling Key.isDown() with the appropriate key code. 
     * But in Actionscript 3 Key.isDown no longer exists and the only intrinsic way to react to the keyboard 
     * is via the keyUp and keyDown events.</p>
     * 
     * <p>The KeyPoll class rectifies this. It has isDown and isUp methods, each taking a key code as a 
     * parameter and returning a Boolean.</p>
     */
     class KeyPoll
    {
        private var states:ByteArray;
        private var dispObj:DisplayObject;
        
        /**
         * Constructor
         * 
         * @param stage A display object on which to listen for keyboard events.
         * To catch all key events, this should be a reference to the stage.
         */
        public function KeyPoll( stage:DisplayObject )
        {
            states = new ByteArray();
            states.writeUnsignedInt( 0 );
            states.writeUnsignedInt( 0 );
            states.writeUnsignedInt( 0 );
            states.writeUnsignedInt( 0 );
            states.writeUnsignedInt( 0 );
            states.writeUnsignedInt( 0 );
            states.writeUnsignedInt( 0 );
            states.writeUnsignedInt( 0 );
            dispObj = stage;
            dispObj.addEventListener( KeyboardEvent.KEY_DOWN, keyDownListener, false, 0, true );
            dispObj.addEventListener( KeyboardEvent.KEY_UP, keyUpListener, false, 0, true );
            dispObj.addEventListener( Event.ACTIVATE, activateListener, false, 0, true );
            dispObj.addEventListener( Event.DEACTIVATE, deactivateListener, false, 0, true );
        }
        
        private function keyDownListener( ev:KeyboardEvent ):void
        {
            states[ ev.keyCode >>> 3 ] |= 1 << (ev.keyCode & 7);
        }
        
        private function keyUpListener( ev:KeyboardEvent ):void
        {
            states[ ev.keyCode >>> 3 ] &= ~(1 << (ev.keyCode & 7));
        }
        
        private function activateListener( ev:Event ):void
        {
            for ( var i:int = 0; i < 32; ++i )
            {
                states[ i ] = 0;
            }
        }

        private function deactivateListener( ev:Event ):void
        {
            for ( var i:int = 0; i < 32; ++i )
            {
                states[ i ] = 0;
            }
        }
        
        /**
         * To test whether a key is down.
         *
         * @param keyCode code for the key to test.
         *
         * @return true if the key is down, false otherwise.
         *
         * @see #isUp()
         */
        public function isDown( keyCode:uint ):Boolean
        {
            return ( states[ keyCode >>> 3 ] & (1 << (keyCode & 7)) ) != 0;
        }
        
        /**
         * To test whether a key is up.
         *
         * @param keyCode code for the key to test.
         *
         * @return true if the key is up, false otherwise.
         *
         * @see #isDown()
         */
        public function isUp( keyCode:uint ):Boolean
        {
            return ( states[ keyCode >>> 3 ] & (1 << (keyCode & 7)) ) == 0;
        }
    }