/**
 * Copyright Highly ( http://wonderfl.net/user/Highly )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uZVrC
 */

// forked from Highly's sierpinsky circles
package {
    import flash.utils.Proxy;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.geom.*;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var gfx:Sprite = new Sprite();
            var c:int = 0x0000FF;
            gfx.graphics.lineStyle(1,c);
            addChild(gfx);
            var sw:int = stage.stageWidth;
            var sh:int = stage.stageHeight;
            var ti:Timer = new Timer(1,0);
            const sAng:Number = 90;//starting angle for sierpinksy triangle
            const tAng:Number = 90;//angle mod for triangle
            const rotMax:int = 3;
            ti.addEventListener(TimerEvent.TIMER,tmr);
            ti.start();
            var out1:TextField = new TextField();
            var tfo:int = 10;
            out1.x = tfo;
            out1.y = tfo;
            out1.width = sw - tfo*2;
            out1.height = sh - tfo*2;
            out1.selectable = true;
            out1.background = false;
            out1.wordWrap = true;
            //addChild(out1);
            var pa:Array= new Array();//point array to hold points to be drawn
            pa = [new Point(sh/2,sw/2)];
            var itr:int = 9;//how manyb iterations to draw
            var count:int=0;
            var pcount:int=0;
            var dist:Number = 200;//starting distance
            var dmod:Number = 0.5;//modifier for the distance variable
            var cw:Number = 47;
            var cm:Number = 0.5;
            function tmr(e:TimerEvent):void{
                if(count < itr){
                    if(pcount<pa.length){
                        
                        gfx.graphics.drawCircle(pa[pcount].x,pa[pcount].y,cw);
                        ++pcount;
                        
                    }else{
                        dist = dist*dmod;
                        cw=cw*cm;
                        pa = SPT(pa,dist);
                        pcount = 0;
                        ++count;
                    }
                }

            }
            //sierpinskey triangle point function
            //Requires starting list of points and starting distance
            //returns an array of points
            function SPT(a:Array, d:Number):Array{
                var ra:Array = new Array();//return array
                for(var i:int=0;i<a.length;++i){
                    for(var j:int = 0;j<rotMax;++j){//this loop is to add points around the modpoint according to how many points are defined or necesary (sierpinksy triangle = 3
                        var tp:Point = new Point();
                        tp = getCart(d,(tAng*j)-35);
                        tp.x += a[i].x;
                        tp.y += a[i].y;
                        ra.push(tp);
                        //trace(tp);
                        //trace(sAng+tAng*j);
                    }
                }

                return ra;
            }
            function getCart(r:Number, q:Number) : Point {
                var x:Number = r * Math.cos(q);
                var y:Number = r * Math.sin(q);
                return new Point(x,y);
            }
            function toRad(deg:Number):Number{
                return deg * Math.PI*180;
            }
            function trace(o:Object):void{
                out1.appendText(o+"\n");
            }


        }
    }
}