/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uYi8
 */

package {
    import flash.display.Sprite;
    import flash.utils.Dictionary;
    import flash.sampler.getSize;
    import flash.events.Event;
    import flash.system.System;
    import flash.text.TextField;
    
    public class MemoryTest extends Sprite {
    	
    		private var _obj: Object;
    		private var _dict: Dictionary;
    		private var _init: String;
    		private var _tf: TextField;
    		private var _arr: Array;
    		
   		public function MemoryTest() {
   			
            _obj = {};
            _arr = [];
            _dict = new Dictionary();
            _init = "Works only with debug player: \nStart Size: " + getSizes() + "\n";
            addChild( _tf = new TextField( ) );
     
            _tf.width = 200;
            fill();
            _init += "After Filling: " + getSizes()+"\n";
            delete _obj[12345];
            delete _obj[12354];
            _obj[18] = null;
            _obj[40] = null;
            delete _obj[40];
            _obj[4999] = undefined;
            delete _dict[12345];
            delete _dict[12354];
            delete _dict[18];
            delete _dict[40];
            delete _dict[4999];
            _arr.splice( 12345, 1 );
            _arr.splice( 12354, 1 );
            _arr.splice( 18, 1 );
            _arr.splice( 40, 1 );
            _arr.splice( 4999, 1 );
           	
            addEventListener( Event.ENTER_FRAME, checkSizeNow );
        }
        
        public function fill(): void {
       	 	_obj[12345] = true;
       	 	_obj[12354] = true;
       	 	_obj[18] = true;
       	 	_obj[40] = true;
       	 	_obj[4999] = true;
       	 	_dict[12345] = true;
       	 	_dict[12354] = true;
       	 	_dict[18] = true;
       	 	_dict[40] = true;
       	 	_dict[4999] = true;
            _arr[ 12354 ] = true;
            _arr[ 12345 ] = true;
            _arr[ 18 ] = true;
            _arr[ 40 ] = true;
            _arr[ 4999 ] = true;
        }
        
        private function getSizes(): String {
        		return getSize( _obj ) + ", " + getSize( _dict ) + ", " + getSize( _arr );
        }

        private function checkSizeNow( event: Event ): void {
        		_tf.text = _init + "Current Size: " + getSizes() + "\nArray length: " + _arr.length;
        		System.gc();
        }        
    }
}