/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uYWK
 */

package{

       import flash.events.*;
       import flash.display.*;
       import org.papervision3d.cameras.*;
       import org.papervision3d.materials.*;
       import org.papervision3d.materials.special.*;
       import org.papervision3d.materials.utils.*;
       import org.papervision3d.objects.primitives.*;
       import org.papervision3d.render.*;
       import org.papervision3d.scenes.*;
       import org.papervision3d.view.*;
       import org.papervision3d.view.stats.StatsView;

       public class Camera1 extends Sprite{

               static public const OBJ_MAX:int = 500;

               private var camera:Camera3D = new Camera3D(60,10,2000,true,false);
               private var renderer:BasicRenderEngine = new BasicRenderEngine();
               private var scene:Scene3D = new Scene3D();
               private var viewport:Viewport3D = new Viewport3D();

               public function Camera1(){

                       addChild(viewport);
                       addChild(new StatsView(renderer));

                       var material:CompositeMaterial = new CompositeMaterial();
                       material.addMaterial(new ColorMaterial(0x000000,0.25));
                       material.addMaterial(new WireframeMaterial(0xffffff));

                       for(var i:int =0; i< OBJ_MAX; i++){

                               var cube:Cube = new Cube(new MaterialsList({all:material}), 50,50,50,1,1,1);

                               scene.addChild(cube);

                               cube.x = ((i % 6) - 3) * 100;
                               cube.z = Math.floor(i /6)* 200;
                               cube.y = -100;
                       }

                       addEventListener(Event.ENTER_FRAME,loop);

               }

               private function loop(e:Event):void{

                       camera.z += 20;
                       if(camera.z > 100) camera.z =-2000;

                       renderer.renderScene(scene,camera,viewport);
               }
       }
}