/**
 * Copyright Hasufel ( http://wonderfl.net/user/Hasufel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uYB8
 */

package {
    //******************************************************
    //The Island: PerlinDisplacementFilter
    //@by Hasufel 2010
    //*****************************************************/
        
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.ByteArray;
    import flash.utils.Timer;
    import flash.utils.getTimer;

    [SWF(width=465, height=465, backgroundColor=0,frameRate=60)]

    public class PerlinDisplacementFilter extends Sprite {
        private const _stageW:uint = stage.stageWidth;
        private const _stageH:uint = stage.stageHeight;
        private const _point:Point = new Point(0,0);
        private const _numOct:uint = 2;
        private const _scaleX:uint = 15; //horizontal speed of water
        private const _scaleY:uint = 3; //vertical speed of water
        private const _graphicsData:Array =["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","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"];
        private var _renderData:BitmapData;
        private var _renderRect:Rectangle;
        private var _renderBitmap:Bitmap;
        private var _topBitmap:Bitmap;

        private var _perlinSizeW:uint;
        private var _perlinSizeH:uint;
        private var _map:DisplacementMapFilter;            
        private var _perlinData:BitmapData;
        private var _perlinBitmap:Bitmap;

        private var _offsets:Array = new Array;
        private var _freq:Vector.<uint> = new Vector.<uint>(_numOct*2,true);
        private var _phase:Vector.<uint> = new Vector.<uint>(_numOct*2,true);        
        
        private var _loader:Loader;
        private var _assetsMemoryBank:Array=[];
        private var _assetsNum:uint = 0;


        public function PerlinDisplacementFilter (){
            setProps(stage, {quality:StageQuality.LOW,scaleMode:StageScaleMode.NO_SCALE,align:StageAlign.TOP_LEFT});
            prepareAsset(0);
        }

        private function prepareAsset(n:int):void{
            var bytes:ByteArray = new ByteArray();
            var data1:Array=_graphicsData[n].split("");
            var data2:Array=[];
            var d1l:int = data1.length;
            for (var i:int=0;i<d1l;i+=2){
                data2.push("0x"+data1[i]+data1[i+1]);
            }
            var d2l:int = data2.length;
            for (var j:int=0;j<d2l;j++){
                bytes[j] = data2[j];
            }
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE,assetsLoaded);
            _loader.loadBytes(bytes);
        }

        private function assetsLoaded(event:Event):void {
            _assetsMemoryBank.push(_loader.content);
            _assetsNum++;
            if (_assetsNum<_graphicsData.length) {prepareAsset(_assetsNum);}
            else {initAnimation();}
        }

        private function initAnimation():void {
            _perlinSizeW = _assetsMemoryBank[0].bitmapData.width;
            _perlinSizeH = _assetsMemoryBank[0].bitmapData.height;
            _renderData = new BitmapData(_perlinSizeW,_perlinSizeH,false,0x000000);
            _renderRect = new Rectangle(0,0,_perlinSizeW,_perlinSizeH);
            _renderData.draw(_assetsMemoryBank[0].bitmapData);
            _perlinData = new BitmapData(_perlinSizeW,_perlinSizeH,false,0x000000);
            _perlinBitmap = new Bitmap(_perlinData);
            _renderBitmap = new Bitmap(_renderData.clone());
            setProps(_renderBitmap, {x:Math.round(_stageW/2 - 160),y:_assetsMemoryBank[1].bitmapData.height - _scaleY + Math.round(_stageH/2 - 112)});
            addChild(_renderBitmap);
            _topBitmap = new Bitmap(_assetsMemoryBank[1].bitmapData);
            setProps(_topBitmap, {x:Math.round(_stageW/2 - 160),y:Math.round(_stageH/2 - 112)});
            addChild(_topBitmap);
            for (var i:uint=0;i<_numOct;i++) {
                _offsets.push(new Point());
                _freq[i] = Math.round(5*Math.random()+1);
                _freq[i+1] = Math.round(6*Math.random()+1);
                _phase[i] = Math.round(2*Math.PI*Math.random());
                _phase[i+1] = Math.round(2*Math.PI*Math.random());
            }
            _perlinData.perlinNoise(_perlinSizeW,_perlinSizeH,_numOct,128,true,false,7,false,_offsets);
            _perlinBitmap.transform.colorTransform = new ColorTransform(1,0,0,1);//red channel only
            _map = new DisplacementMapFilter(_perlinData, _point, BitmapDataChannel.RED
, BitmapDataChannel.RED,_scaleX,_scaleY, DisplacementMapFilterMode.WRAP);
            addEventListener(Event.ENTER_FRAME, renderDisplay);
        }

        private function renderDisplay(e:Event):void {
            var t:Number = getTimer()*.0001;
            for (var i:uint=0;i<_numOct;i++) {
                _offsets[i].x = _perlinSizeW*Math.cos(_freq[i]*t+_phase[i]);
                _offsets[i].y = _perlinSizeH*Math.sin(_freq[i+1]*t+_phase[i+1]);
            }
            _perlinData.perlinNoise(_perlinSizeW,_perlinSizeH,_numOct,128,true,false,7,false,_offsets);
            _renderBitmap.bitmapData.applyFilter(_renderData,_renderRect,_point,_map);
        }

        private function setProps(o:*,p:Object):void {
            for (var k:String in p) {o[k]=p[k];}
        }
    }
}