/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uXxC
 */

// forked from ProjectNya's DisplacementMapFilter + PerlinNoise (2)
////////////////////////////////////////////////////////////////////////////////
// DisplacementMapFilter + PerlinNoise [BitmapData.applyFilter版]
//
// 置き換えマップ効果 (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=480
// BitmapDataでノイズ生成 (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=481
// [AS3.0] PerlinNoiseクラスに挑戦！
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1114
//
// 動作を軽くするための方法 (東京てらこ7 @trick7)
// Bitmap.filters を使わず、BitmapData.applyFilter() を用いる
////////////////////////////////////////////////////////////////////////////////

package {
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.filters.*;
    import flash.display.*;
    import flash.net.*;
    import flash.utils.*;
    import flash.system.*;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var fgLoader:Loader;
        private var bgLoader:PhotoLoader;
        private var fgBitmapData:BitmapData;
        private var fgBitmap:Bitmap;
        private var bgBitmapData:BitmapData;
        private var bgBitmap:Bitmap;

        private var fgAlpha:Number = 0.65;
		
        private var fgUrl:String = "http://swf.wonderfl.net/swf/usercode/5/5c/5c5c/5c5c8afbda98967c95053cb980c95fb81d9b2f6b.swf";
        //private var fgUrl:String = "http://farm3.static.flickr.com/2444/3839495982_12d0e4ecc8_o.png"; 
        //private var fgUrl:String = "http://www.project-nya.jp/images/flash/piyo.png";
        //private var bgUrl:String = "http://farm5.static.flickr.com/4057/4498733907_68e3d30ae2_b.jpg";
        private var bgUrl:String = "http://farm4.static.flickr.com/3281/2978651767_c5895bb835_b.jpg"; // from: http://www.flickr.com/photos/pinksherbet/2978651767/
        private var map:DisplacementMapFilter;
        private var blur:BlurFilter = new BlurFilter(1.5,1.5,2);

        private static var color:uint = BitmapDataChannel.RED;

        private var slider1:Slider;
        private var slider2:Slider;
        private var scale:Number = 15;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init1();
        }

        private function init1():void {
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);

            // map = new DisplacementMapFilter(noise, new Point(), color, color, scale, scale, DisplacementMapFilterMode.CLAMP);

            fgLoader = new Loader();
            fgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, init2);
            fgLoader.load(new URLRequest(fgUrl), new LoaderContext(true));

            fgBitmap = new Bitmap(new BitmapData(465, 465, true, 0x00000000));
        }

        private function init2(evt:Event):void {
            // fgBitmapData = Bitmap(evt.target.content).bitmapData;
            // fgBitmap.bitmapData = fgBitmapData.clone();

            bgLoader = new PhotoLoader();
            bgLoader.addEventListener(Event.INIT, initialize, false, 0, true);
            bgLoader.load(bgUrl, true);

            bgBitmap = new Bitmap(new BitmapData(465, 465, true, 0x00000000));

            slider1 = new Slider();
            slider1.x = 72;
            slider1.y = 405;
            slider1.init({label: "scale", width: 200, min: 0, max: 100, grid: 10, init: 15});
            slider1.addEventListener(CompoEvent.CHANGE, change1, false, 0, true);

            slider2 = new Slider();
            slider2.x = 292;
            slider2.y = 405;
            slider2.init({label: "alpha", width: 100, min: 0, max: 100, grid: 10, init: 65});
            slider2.addEventListener(CompoEvent.CHANGE, change2, false, 0, true);

            // slider2 = new Slider();
            // slider2.x = 292;
            // slider2.y = 405;
            // addChild(slider2);
            // slider2.init({label: "amplitude", width: 100, min: 0, max: 50, grid: 5, init: 2});
            // slider2.addEventListener(CompoEvent.CHANGE, change2, false, 0, true);
        }
        private function initialize(evt:Event):void {
            bgBitmapData = Bitmap(evt.target.content).bitmapData;
            bgBitmap.bitmapData = bgBitmapData.clone();
            
            // soften displacement map
            bgBitmap.bitmapData.applyFilter(bgBitmap.bitmapData, bgBitmap.bitmapData.rect, new Point, new BlurFilter(8,8,8));
            
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);

            //addChild(bgBitmap); // background
            addChild(bgLoader); // background
            addChild(fgLoader); // foreground
            fgLoader.blendMode = "layer";

            fgLoader.alpha = 0.65;

            scrollRect = new Rectangle(0,0,465,465);
            addChild(slider1);
            addChild(slider2);


        }

        
        private function update(evt:Event):void {
            //loader.filters = [map];
            // bitmap.bitmapData.lock();
            // bitmap.bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(), map);
            // bitmap.bitmapData.unlock();
            map = new DisplacementMapFilter(bgBitmapData, new Point(), color, color, scale, scale, DisplacementMapFilterMode.CLAMP);
            fgLoader.filters = [map];
        }

        private function change1(evt:CompoEvent):void {
            scale = evt.value;
        }

        private function change2(evt:CompoEvent):void {
            fgLoader.alpha = evt.value/100;
        }

    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.display.Bitmap;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:Bitmap;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        content = Bitmap(info.content);
        if (smoothing) content.smoothing = true;
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }

}


//////////////////////////////////////////////////
//     Sliderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.events.Event;
import flash.events.MouseEvent;

class Slider extends Sprite {
    private var hole:Shape;
    private var line:Sprite;
    private var thumb:Sprite;
    private var light:Shape;
    private var shade:Shape;
    private var base:Shape;
    private var title:TextField;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 100;
    private static var tHeight:uint = 20;
    private static var bHeight:uint = 30;
    private var grid:uint = 5;
    private static var bColor:uint = 0xFFFFFF;
    private static var tColor:uint = 0x666666;
    private static var gColor:uint = 0x999999;
    private static var mColor:uint = 0x333333;
    private static var bgColor:uint = 0x0099FF;
    private static var sColor:uint = 0x000000;
    private static var offColor:uint = 0x999999;
    private var min:Number = 0;
    private var max:Number = 100;
    private var initValue:Number = 0;
    private var blueGlow:GlowFilter;
    private var shadeDrop:DropShadowFilter;
    private var value:Number;
    private var _enabled:Boolean = true;

    public function Slider() {
    }

    public function init(option:Object):void {
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.min != undefined) min = option.min;
        if (option.max != undefined) max = option.max;
        if (option.grid != undefined) grid = option.grid;
        if (option.init != undefined) initValue = option.init;
        draw();
    }
    private function draw():void {
        shadeDrop = new DropShadowFilter(1, 90, sColor, 0.5, 4, 4, 2, 3, false, false);
        blueGlow = new GlowFilter(bgColor, 0.6, 5, 5, 2, 3, false, true);
        hole = new Shape();
        line = new Sprite();
        title = new TextField();
        txt = new TextField();
        thumb = new Sprite();
        shade = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(hole);
        addChild(line);
        addChild(title);
        addChild(txt);
        addChild(thumb);
        thumb.addChild(shade);
        thumb.addChild(light);
        thumb.addChild(base);
        hole.y = bHeight;
        createGradientHole(hole, _width, 3);
        line.y = bHeight;
        createGrid(line);
        title.height = tHeight-1;
        title.type = TextFieldType.DYNAMIC;
        title.selectable = false;
        //title.embedFonts = true;
        //title.antiAliasType = AntiAliasType.ADVANCED;
        title.textColor = tColor;
        title.autoSize = TextFieldAutoSize.LEFT;
        var tfl:TextFormat = new TextFormat();
        tfl.font = fontType;
        tfl.size = 12;
        tfl.align = TextFormatAlign.LEFT;
        title.defaultTextFormat = tfl;
        title.text = label;
        //txt.x = title.textWidth;
        txt.x = 50;
        txt.width = 50;
        txt.height = tHeight-1;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tfr:TextFormat = new TextFormat();
        tfr.font = fontType;
        tfr.size = 12;
        tfr.align = TextFormatAlign.RIGHT;
        txt.defaultTextFormat = tfr;
        reset();
        thumb.y = bHeight;
        createThumb(shade, 8, 20, 12, sColor);
        shade.filters = [shadeDrop];
        createThumb(light, 8, 20, 12, bgColor);
        light.filters = [blueGlow];
        createThumb(base, 8, 20, 12, bColor);
        _up();
        enabled = true;
        thumb.mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
        var rect:Rectangle = new Rectangle(0, bHeight, _width, 0);
        thumb.startDrag(false, rect);
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        thumb.addEventListener(Event.ENTER_FRAME, change, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        _up();
        thumb.stopDrag();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        thumb.removeEventListener(Event.ENTER_FRAME, change);
    }
    private function leave(evt:Event):void {
        _up();
        thumb.stopDrag();
        checkValue();
        dispatchEvent(new CompoEvent(CompoEvent.SELECT, value));
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        thumb.removeEventListener(Event.ENTER_FRAME, change);
    }
    private function _up():void {
        light.visible = false;
    }
    private function _over():void {
        light.visible = true;
    }
    private function _down():void {
        light.visible = true;
    }
    private function _off():void {
        light.visible = false;
        txt.textColor = offColor;
    }
    private function change(evt:Event):void {
        _down();
        checkValue();
        dispatchEvent(new CompoEvent(CompoEvent.CHANGE, value));
    }
    private function checkValue():void {
        value = min + Math.round(thumb.x/_width*(max-min));
        txt.text = String(value);
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        if (!_enabled) _off();
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        if (_enabled) {
            thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        } else {
            thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        }
    }
    public function reset():void {
        thumb.x = _width*(initValue-min)/(max-min);
        value = initValue;
        txt.text = String(value);
    }
    private function createGrid(target:Sprite):void {
        for (var n:uint = 0; n <= grid; n++) {
            var w:uint = Math.floor(_width/grid);
            if (n == 0 || n == grid*0.5 || n == grid) {
                createGridLine(target, w*n, mColor);
                var _txt:TextField = new TextField();
                target.addChild(_txt);
                _txt.x = w*n - 20;
                _txt.y = 13;
                _txt.width = 40;
                _txt.height = 14;
                _txt.selectable = false;
                //_txt.embedFonts = true;
                //_txt.antiAliasType = AntiAliasType.ADVANCED;
                //_txt.antiAliasType = AntiAliasType.NORMAL;
                _txt.textColor = mColor;
                var tfc:TextFormat = new TextFormat();
                tfc.font = fontType;
                tfc.size = 8;
                tfc.align = TextFormatAlign.CENTER;
                _txt.defaultTextFormat = tfc;
                if (n == 0) _txt.text = String(min);
                if (n == grid*0.5) _txt.text = String(min+(max-min)*0.5);
                if (n == grid) _txt.text = String(max);
            } else {
                createGridLine(target, w*n, gColor);
            }
        }
    }
    private function createThumb(target:Shape, w:uint, h:uint, y:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -y, w, h, w);
        target.graphics.endFill();
    }
    private function createGradientHole(target:Shape, w:uint, c:Number):void {
        var colors:Array = [0x000000, 0x000000];
        var alphas:Array = [0.4, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w+c*2, c*2, 0.5*Math.PI, -c, -c);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-c, -c, w+c*2, c*2, c*2);
        target.graphics.endFill();
    }
    private function createGridLine(target:Sprite, x:uint, color:uint):void {
        target.graphics.lineStyle(0, color);
        target.graphics.moveTo(x, 8);
        target.graphics.lineTo(x, 12);
    }

}


//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}
