/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uXQt
 */

package{
    import flash.events.Event;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.*;
    import flash.text.TextFieldAutoSize;
    
    public class Test extends Sprite{
        private var canvas:BitmapData;
        private var textCanvas:BitmapData;
        private var particles:Array;
        private var _num:int;
        
        public function Test(){
            init();
        }//init
        private function init():void{
            //背景の作成
            canvas = new BitmapData(465, 465, false, 0x000000);
            addChild(new Bitmap(canvas));    
            
            //テキストフィールドの作成
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat(null,80,0xFFFFFF);
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = "おぎやはぎ";//好きなテキストを中にいれれば。
            //テキストと同じ大きさのbitmapdataを作る
            textCanvas = new BitmapData(tf.textWidth, tf.textHeight, false, 0x000000);
            //テキストをtextCanvasにドローする
            textCanvas.draw(tf);
            //配列Particlesを初期化する
            particles = new Array();
            //テキストを作成するcreateTextを実行
            createText();

            addEventListener(Event.ENTER_FRAME, onEnter);
           // stage.addEventListener(MouseEvent.CLICK, onClick);   
        }//init
        
        //1pxごとに色を取得すし、黒以外の色であればピクセル作成するfunction createTextを作る
        private function createText():void{
            //xの開始位置
           // var ofx:Number = 465 / 2 - textCanvas.width / 2; 
            //yの開始位置
           // var ofy:Number = 465 / 2 - textCanvas.height / 2; 
            //textCanvasの幅分繰り返す
            for(var i:Number = 0; i < textCanvas.width; i++){
                //textCanvasの高さ分繰り返す
                for(var j:Number = 0; j < textCanvas.height; j++){
                    //各ピクセルの色情報を習得
                    var c:uint = textCanvas.getPixel(i, j);　
                    //もし黒以外なら
                    if(c != 0x000000){　
                        createParticle(i , j, c); //+ ofx, j * ofy, c);
                    }//if
                }//for j
            }//for i
        }//createText
        
        ///の情報と、位置の情報を取得して格納するfunction createParticleを作る
        private function createParticle(ex:Number, ey:Number, c:int):void{
            //Particleのインスタンスを作る
            var p:Particle = new Particle();
            p.ex = ex;
            p.ey = ey;
            p.c = c;
            //initParticleを実行する
            initParticle(p);
            //配列particlesにパーティクルpを格納する
            particles.push(p);
            _num = 0;   
        }//createParticle
        
        //位置の情報をもとに、ランダムで散らばるようなアクションを作成すfunction initParticleを作る
        private function initParticle(p:Particle):void{
            var rad:Number = Math.random() * (Math.PI * 2);
            var dis:Number = Math.random() * 400;
            p.x = p.ex + dis * Math.cos(rad);
            p.y = p.ey + dis * Math.sin(rad);
        }//initParticle
        
        private function onEnter(e:Event):void{
            //canvas自体は黒でロックしておく
            canvas.lock();
            canvas.fillRect(canvas.rect, 0x000000);
            
            for(var i:int = 0; i < _num; i++){
                //配列particlesからi番目のpを取得する？
                var p:Particle = particles[i];
                //もしpのxが0.5より小さく、かつxが0.5より小さかったら
                if(Math.abs(p.ex - p.x) < 0.8 && Math.abs(p.ey - p.y) < 0.8){
                    p.x = p.ex;
                    p.y = p.ey;
                //もしそれ以外なら、動く   
                }else{
                    p.x += (p.ex - p.x) * 0.4;
                    p.y += (p.ey - p.y) * 0.4;
                }//if
                //
                canvas.setPixel(p.x, p.y, p.c);
            }//for
            var n:int = particles.length;
            _num = (_num + 100 < n)? _num + 100 : n;//数字は集まる早さ？
            canvas.unlock();
        }//onEnter




    }//class
}//package


class Particle{
    public var x:Number;
    public var y:Number;
    public var ex:Number;
    public var ey:Number;
    public var c:int;
    public function Particle(){
        x = 0;
        y = 0;
        ex = 0;
        ey = 0;
        c = 0;
    }//Particle
}//class

