/**
 * Copyright cuegraphix ( http://wonderfl.net/user/cuegraphix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uVLd
 */

package {
    import flash.display.Sprite;
    import com.bit101.components.HBox;
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import flash.events.Event;
    public class AspectRatio extends Sprite {
    		private var _box:HBox;
    		private var _wInput:InputText;
    		private var _hInput:InputText;
    		private var _aspectLabel:Label;
        public function AspectRatio() {
            _box = new HBox(this, 20, 20);
            _wInput = new InputText(_box, 0, 0, "1920", _change);
            _wInput.width = 50;
            _wInput.restrict = "0-9";
            _hInput = new InputText(_box, 0, 0, "1080", _change);
            _hInput.width = 50;
            _hInput.restrict = "0-9";
            _aspectLabel = new Label(_box);
            _change(null);
        }
        
        private function _change(e:Event):void {
        		var w:int = int(_wInput.text);
        		var h:int = int(_hInput.text);
        		var r:int = gcd(w, h);
        		_aspectLabel.text = w/r + ":" + h/r;
        }
        	
        private function gcd(m:int, n:int):int {
        		if(m < n) {
        			var _temp:int = m;
        			m = n;
        			n = _temp;
        		}
        		if(n == 0) {
        			return m;
        		}
        		var r:int = m % n;
        		if(r) {
        			return gcd(n, r);
        		}
        		return n;
        }
    }
}