/**
 * Copyright kamipoo ( http://wonderfl.net/user/kamipoo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uVCN
 */

/**
 * Papervision3D で マウスイベント を設定する（3）
 * ViewportLayer に マウスイベント を設定する方法
 */
package
{
    import com.bit101.components.TextArea;
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.layer.ViewportLayer;
    
    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]
    public class PV3DMouseEvent3 extends Sprite
    {
        
        //PV3Dに使用する変数
        protected var _scene:Scene3D;
        protected var _viewport:Viewport3D;
        protected var _renderer:BasicRenderEngine;
        protected var _camera:Camera3D;
        
        //表示に使用するマテリアルを格納する変数
        protected var _material:MaterialObject3D;
        
        //表示するプリミティブ（Plane：板、Cube：立方体 など）を格納する変数
        protected var _primitive:DisplayObject3D;
        
        public function PV3DMouseEvent3()
        {
            super();
            
            //3D表示に必要なクラスを初期化します
            _init3D();
            
            //3D表示に必要な情報を設定します
            _setup3D();
            
            //3D空間に追加するオブジェクトを生成します
            _initObject();
            
            //生成したオブジェクトに マウスイベント を設定します
            _setupObject();
            
            //毎フレーム レンダリングを行います。
            addEventListener( Event.ENTER_FRAME, _enterframeHandler );
            
            
            //ログ出力を初期化します（無視して結構です。）
            _initLogger();
        }
        
        /**
         * PV3Dでボタンを使えるようにセットアップします。
         */
        protected function _setup3D():void
        {
        }
        
        /**
         * PV3Dのオブジェクトを追加します。
         */
        protected function _initObject():void
        {
            _material = new ColorMaterial( 0x000000, 1, false );
            
            //マテリアルの interactive プロパティを true に設定します。
            _material.interactive = true;
            
            //裏面の描画を有効化します。
            _material.doubleSided = true;
            
            //今回は Plane を追加します。
            _primitive = new Plane( _material, 100, 100, 1, 1 );
            
            //シーンに追加します。
            _scene.addChild( _primitive );
            
            //3Dなのでオブジェクトを回転させておきます。
            var t:ITween = BetweenAS3.to(_primitive, {rotationY: 360}, 10);
            t.stopOnComplete = false;
            t.play();
        }
        
        /**
         * PV3Dに追加したオブジェクトにマウスイベントを設定します
         */
        protected function _setupObject():void
        {
            //ViewportLayer を取得する
            var viewportLayer:ViewportLayer = _viewport.getChildLayer( _primitive );
            
            //ViewportLayer の buttonMode を true に設定する
            viewportLayer.buttonMode = true;
            
            viewportLayer.addEventListener( MouseEvent.ROLL_OVER, _logEvent );
            viewportLayer.addEventListener( MouseEvent.ROLL_OUT, _logEvent );
            viewportLayer.addEventListener( MouseEvent.CLICK, _logEvent );
        }
        
        /**
         * オブジェクトをクリックした時に発生するイベント
         */
        protected function _logEvent(e:Event):void
        {
            //出力する
            log( e.type );
        }
        
        /**
         * PV3Dを初期化します。
         */
        protected function _init3D():void
        {
            _scene = new Scene3D();
            _viewport = new Viewport3D( stage.stageWidth, stage.stageHeight - 100, false, false, true, true );
            _renderer = new BasicRenderEngine();
            _camera = new Camera3D();
            _camera.z = -(_camera.zoom * _camera.focus);
            addChild( _viewport );
        }
        
        /**
         * PV3Dを描画します。
         */
        protected function _render():void
        {
            _renderer.renderScene( _scene, _camera, _viewport );
        }
        
        
        protected function _enterframeHandler(e:Event):void
        {
            _render();
        }
        
        
        
        
        
        
        
        
        
        protected var _logger:TextArea;
        
        protected function _initLogger():void
        {
            _logger = new TextArea(this, 0, stage.stageHeight - 101, "");
            _logger.width = stage.stageWidth;
            _logger.height = 100;
        }
        
        public function log(msg:String):void
        {
            if(_logger.text != "") msg = msg + "\n";
            _logger.text = msg + _logger.text;
        }
    }
}