/**
 * Copyright peace_s ( http://wonderfl.net/user/peace_s )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uUv2
 */

// forked from clockmaker's [PV3D] Vector Font on 3D World
package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.filters.*;
	import flash.utils.getTimer;
	import org.papervision3d.core.clipping.FrustumClipping;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.cameras.*;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.typography.fonts.HelveticaBold;
	import org.papervision3d.typography.Text3D;
	import org.papervision3d.core.effects.view.ReflectionView;
	import caurina.transitions.properties.CurveModifiers;
	import caurina.transitions.Tweener;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0x001122")]
	
		
	public class Main extends ReflectionView
	{
		static private const ROUND           :uint = 2000;
		static private const OBJ_AMOUNT      :uint = 30;
		static private const CAMERA_POSITION :uint = 2000;
		static private const PLANE_SIZE      :uint = 3000;
		static private const COLOR_LIST      :Array  = [0x003399, 0x0066CC, 0x0099FF, 0x33CCFF];
		
		private var wraps:Array = [];
		private var words:Array = [];
		private var wrapRoot:DisplayObject3D;
		
		public function Main():void 
		{
			super(0, 0, true , false, CameraType.TARGET);
			
			camera.zoom = 1.5;
			camera.focus = 200;
			
			// refrection
			surfaceHeight = 0;
			//viewportReflection.filters = [new BlurFilter(2, 2, 3)];
			viewportReflection.alpha = .25;
			
			// safe polygon
			renderer.clipping = new FrustumClipping(FrustumClipping.NEAR)
			
			// add material
			var compMat:CompositeMaterial = new CompositeMaterial();
			compMat.addMaterial(new WireframeMaterial(0xEEEEEE));
			compMat.addMaterial(new ColorMaterial(0xEEEEEE, 0.1));
			
			var planeB:Plane = new Plane(compMat, PLANE_SIZE, PLANE_SIZE, 4, 4);
			planeB.pitch(90)
			scene.addChild(planeB);
			
			wrapRoot = scene.addChild(new DisplayObject3D());
			
			// particle motion
			var cnt:int = 0;
			// A-Z
			var str:String = "speed";
				var char:Array = new Array(str);
			for (var i:int = 0; i < OBJ_AMOUNT; i++ )
			{
				var wrap:DisplayObject3D = wrapRoot.addChild(new DisplayObject3D());
				wrap.y = ROUND * Math.random();
				wraps.push(wrap);
				
				
				
				// letter
				var lettermat:Letter3DMaterial = new Letter3DMaterial();
				lettermat.fillColor = COLOR_LIST[ COLOR_LIST.length * Math.random() | 0];
				var word:Text3D = new Text3D(char[i] , new HelveticaBold() , lettermat);
				
				word.z = 500 * Math.random() + 500;
				word.rotationY = 360 * Math.random();
				word.scale = 5 * Math.random() + 0.5;
				wrap.addChild(word);
				
				words.push(word)
			}

			stage.addEventListener(Event.ENTER_FRAME, loop)
		}
		
		private function loop(event:Event = null):void 
		{
			var i:int = wraps.length;
			while (i--) wraps[i].rotationY += i / 25;
			
			i = words.length;
			while (i--) words[i].rotationY += 4;
			
			camera.x += (CAMERA_POSITION * Math.sin(mouseX / stage.stageWidth * 360 * Math.PI / 180) - camera.x) * .1;
			camera.z += (CAMERA_POSITION * Math.cos(mouseX / stage.stageWidth * 360 * Math.PI / 180) - camera.z) * .1;
			camera.y += (CAMERA_POSITION * mouseY / stage.stageHeight - camera.y) * .1;
			
			singleRender();
		}
	}
}