/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uTyf
 */

package {
    import com.bit101.components.*;
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    public class main extends Sprite
    {
        protected var mainSprite :Sprite = new Sprite;        
        
        public function main()
        {
            addChild(mainSprite);
            
            mainSprite.graphics.beginFill (0x000000, 0.5);
            mainSprite.graphics.drawRect  (0, 0, 100, 100);
            mainSprite.graphics.endFill   ();
            
            //apply axis propogation after draw to prevent verbose math
            mainSprite.x = ((stage.stageWidth / 2) - (mainSprite.width / 2));
            mainSprite.y = ((stage.stageHeight / 2) - (mainSprite.height / 2));

            mainSprite.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, onMouseWheel);
        }
        
        public function zoomSprite(value:Number) :void
        {
             mainSprite.x      -= (value / 2);
             mainSprite.y      -= (value / 2);
             mainSprite.width  += (value);
             mainSprite.height += (value);
        }
        
        protected var $eObj :Object;
        
        protected var firstPoint   :Point = new Point;
        protected var currentPoint :Point = new Point;
        protected var calcPoint    :Point = new Point;

        public function onMouseDown($e:MouseEvent) :void
        {
            if ($e.target == mainSprite)
            {
                $eObj = $e.target;
                
                firstPoint = new Point(mouseX, mouseY);
                stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
                stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            }
        }
        
        public function onEnterFrame($e:Event) :void
        {
            currentPoint = new Point(mouseX, mouseY);
            calcPoint = currentPoint.subtract(firstPoint);
            
            mainSprite.x = (mainSprite.x + calcPoint.x);
            mainSprite.y = (mainSprite.y + calcPoint.y);
            
            firstPoint = currentPoint;
        }
        
        public function onMouseUp($e:MouseEvent) :void
        {
            $eObj = null;
            
            stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        public function onMouseWheel($e:MouseEvent) :void
        {
            mainSprite.x += 10;
            
            if (width > 50 && height > 50)
            {
                zoomSprite($e.delta);
            }else{
                if ($e.delta > 0)
                {
                    zoomSprite($e.delta);
                }
            }
        }
        
        public function refreshStage() :void
        {
            stage.invalidate();
        }
    }
}