/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uTxR
 */

package  
{
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2World;
	import Box2D.Dynamics.b2BodyDef;
	import Box2D.Collision.Shapes.b2PolygonDef;
	import Box2D.Collision.Shapes.b2CircleDef;
	import Box2D.Dynamics.b2Body;
	import Box2D.Collision.Shapes.b2Shape;
	import Box2D.Collision.Shapes.b2CircleShape;
	import Box2D.Dynamics.b2DebugDraw;
	import flash.display.Sprite;
	import flash.geom.Rectangle;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	* ほとんどコレです。
	* http://nutsu.com/blog/2008/082521_as_box2d_first.html
	* 
	* @author paq
	*/
	
	[SWF (width="465", height="465", backgroundColor="#222222", frameRate="60")]
	public class Main extends Sprite
	{
		private var world:b2World;
		
		private var WORLD_SCALE:Number = 100; // 100pixel/m
		private var VIEW_RECT:Rectangle;
		private var half_width:Number;
		private var half_height:Number;
		
		private var circles:Array;
		
		public function Main() 
		{
			super();
			
			VIEW_RECT   = new Rectangle( 0, 0, stage.stageWidth/WORLD_SCALE, stage.stageHeight/WORLD_SCALE );
			half_width  = stage.stageWidth * 0.5;
			half_height = stage.stageHeight * 0.5;
			
			circles = [];
			
			initWorld();
			initDraw();
			createWall();

			addCircle( VIEW_RECT.width*0.5, VIEW_RECT.height*0.5 );
			
			addEventListener( Event.ENTER_FRAME, onEnterFrame );
			stage.addEventListener( MouseEvent.CLICK, onClick );
		}
		
		private function initWorld():void
		{
			var aabb:b2AABB = new b2AABB();
			aabb.lowerBound.Set(-1000, -1000);
			aabb.upperBound.Set(1000, 1000);
			
			world = new b2World(aabb, new b2Vec2(0, 10), false);
		}
		
		private function createWall():void
		{
			var wall_size:Number = 0.025;
			
			var wall_side_shape:b2PolygonDef = new b2PolygonDef();
			wall_side_shape.SetAsBox( wall_size, VIEW_RECT.height * 0.5 );
			wall_side_shape.density = 0;
			
			var wall_vt_shape:b2PolygonDef = new b2PolygonDef();
			wall_vt_shape.SetAsBox( VIEW_RECT.width*0.5, wall_size );
			wall_vt_shape.density = 0;
			
			var wall_left:b2BodyDef   = new b2BodyDef();
			var wall_right:b2BodyDef  = new b2BodyDef();
			var wall_bottom:b2BodyDef = new b2BodyDef();
			var wall_top:b2BodyDef    = new b2BodyDef();
			
			wall_left.position.Set(  wall_size, VIEW_RECT.height * 0.5 );
			wall_right.position.Set( VIEW_RECT.width - wall_size, VIEW_RECT.height * 0.5 );
			wall_bottom.position.Set( VIEW_RECT.width * 0.5 , VIEW_RECT.height - wall_size);
			wall_top.position.Set( VIEW_RECT.width*0.5 ,  wall_size);
			
			world.CreateBody( wall_left   ).CreateShape( wall_side_shape );
			world.CreateBody( wall_right  ).CreateShape( wall_side_shape );
			world.CreateBody( wall_bottom ).CreateShape( wall_vt_shape );
			world.CreateBody( wall_top    ).CreateShape( wall_vt_shape );
		}
		
		private function initDraw():void
		{
			var debug_draw:b2DebugDraw = new b2DebugDraw();
			debug_draw.m_sprite        = this;
			debug_draw.m_drawScale     = WORLD_SCALE;
			debug_draw.m_fillAlpha     = 1;
			debug_draw.m_lineThickness = 0;
			debug_draw.m_drawFlags     = b2DebugDraw.e_shapeBit;
			world.SetDebugDraw( debug_draw );
		}
		
		private function addCircle( ax:Number, ay:Number ):void
		{
			var s:b2CircleDef = new b2CircleDef();
			s.density = 1;
			s.restitution = 0.2;
			s.radius = 0.2;
			
			var b:b2BodyDef = new b2BodyDef();
			b.position.Set( ax, ay );
			
			var bb:b2Body  = world.CreateBody( b );
			var bs:b2Shape = bb.CreateShape( s );
			bb.SetMassFromShapes();
			
			circles.push( b2CircleShape(bs) );
		}
		
		private function onClick( e:MouseEvent ):void
		{
			addCircle(mouseX/WORLD_SCALE, mouseY/WORLD_SCALE);
		}
		
		private function onEnterFrame( e:Event ):void
		{
			if ( world )
			{
				for (var i:int = 0; i < circles.length ; i++) 
				{
					var bs:b2CircleShape = circles[i];
					bs.m_radius += 0.1 / WORLD_SCALE;
				}
				world.Step(1/60, 4);
			}
		}
	}
}
