/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uTvK
 */

// forked from sake's リンゴもどき
/*
ワンダフル本のイベント見て、物凄くテンション上がってしまって。
自分も何かリンゴ作りたくなりました。
で、カージオイドを回転させればリンゴに見えるかなーって思って。

・・・あんまリンゴに見えませんね。
もっとリンゴっぽくしたい！
*/
package {
	import flash.display.Sprite;
	import flash.events.Event;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	
	[SWF(backgroundColor="0x000000")]
	public class ringo extends Sprite{
		private var _red:main;
		private var _blue:main;
		private var _bitmapData:BitmapData;
		public function ringo(){
			_red = new main(-50);
			this.addChild(_red);
			_blue = new main(50);
			this.addChild(_blue);
			
			_bitmapData = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
			addChild(new Bitmap(_bitmapData));
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			//_red.onFrame(null);
			//_blue.onFrame(null);
			
			_bitmapData.lock();
			_bitmapData.fillRect(new Rectangle(0,0,stage.stageWidth,stage.stageHeight), 0x000000);
			_bitmapData.draw(_red, null,new ColorTransform(1,0,0,1,0,0,0,0));
			_bitmapData.draw(_blue, null,new ColorTransform(0,1,1,1,0,0,0,0), "add");
			_bitmapData.unlock();
		}
		
	}
}

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.geom.Matrix;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
	class main extends BasicView
	{
		private var pixels:Pixels;
		private var canvas:BitmapData;
		private var mtx:Matrix;
		private var rotateX:Number;
		private var rotateY:Number;
		
		public function main(dX:Number)
		{
			super(0, 0, true, true);
			
			var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, "clear_pre", true);
			layer.clearBeforeRender=true;
			viewport.containerSprite.addLayer(layer);
			camera.x = dX/60;
			camera.z=-22;
			pixels=new Pixels(layer);
			scene.addChild(pixels);
			
			rotateX=rotateY=0;
			
			// りんごの実の部分（カージオイドの回転体）
			for (var i:uint=0; i <= 7000; i++)
			{
				var theta01:Number=i * Math.PI / 180;
				var theta02:Number=random() * 2 * Math.PI;
				
				var r:Number=(-Math.cos(theta01) - Math.sin(theta01) * Math.cos(theta01)) * 7;
				
				var yy:Number=(-Math.sin(theta01) - Math.sin(theta01) * Math.sin(theta01)) * 7 + 4;
				var xx:Number=r * Math.cos(theta02);
				var zz:Number=r * Math.sin(theta02);
				
				var color:uint=(0xff << 24 | 0xff * random() << 16 | 0xff << 8 | 0xff * random());
				color = ARGBtone(color,4);
				var px:Pixel3D=new Pixel3D(color, xx, yy, zz);
				pixels.addPixel3D(px);
			}
			
			// へたの部分（適当な曲線のグラフを散らしてみる）
			for (var j:Number=0; j <= 2; j+=0.02)
			{
				yy=4 * Math.sqrt(j) + 5;
				color=(0xff << 24 | 0x90 << 16 | 0x98 * random() << 8 | 0x00);
				color = ARGBtone(color,4);
				
				var n:int=0;
				while (n < 10)
				{
					px=new Pixel3D(color, j * (0.2 * random() + 0.9), yy * (0.2 * random() + 0.9), 0.6 * random() - 0.3);
					pixels.addPixel3D(px);
					n++;
				}
			}
			
			// キラキラー
			
			canvas=new BitmapData(465 >> 2, 465 >> 2, false, 0x000000);
			/*
			var bmp:Bitmap=new Bitmap(canvas, "never", true);
			bmp.scaleX=bmp.scaleY=4;
			bmp.smoothing=true;
			bmp.blendMode="add";
			addChild(bmp);
			*/
			mtx=new Matrix(0.25, 0, 0, 0.25);
			
			startRendering();
			addEventListener(Event.ENTER_FRAME, onFrame);
		}
		
		private function onFrame(e:Event):void
		{
			canvas.fillRect(canvas.rect, 0x000000);
			canvas.draw(viewport, mtx);
			
			// ローテーション
			rotateX+=(-viewport.containerSprite.mouseX - rotateX) * 0.05;
			rotateY+=(-viewport.containerSprite.mouseY - rotateY) * 0.05;
			pixels.rotationY=rotateX;
			pixels.rotationX=rotateY;
		}
		private function ARGBtone(ARGB:uint, tone:Number):uint {
			var a:int = ARGB >> 24 & 0xff;//16bit右にずらす。 
			var r:int = ARGB >> 16 & 0xff;//16bit右にずらす。 
			var g:int = ARGB >> 8 & 0xff;//8bit右にずらして、下位8bitのみを取り出す 
			var b:int = ARGB & 0xff;//下位8bitのみを取り出す
			r  = Math.min(r * tone,0xFF);
			g  = Math.min(g * tone,0xFF);
			b  = Math.min(b * tone,0xFF);
			a = a << 24;
			r = r << 16;
			g = g << 8;
			return a+r+g+b;
		}

		private var num:Number = 1;
		public function random():Number{
			num = (num*1664525+1013904223)%0x100000000;
			return num/0x100000000;
		}
	}
