/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uSz4
 */

// forked from fakestar0826's MotionTracking
// forked from fakestar0826's ColorTracking
package {
    import flash.filters.ConvolutionFilter;
    import flash.display.BlendMode;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.media.Video;
    import flash.media.Camera;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var _cam:Camera;
        private var _vid:Video;
        private var _bmpd:BitmapData;
        private var _flakes:Array;
        
        public function FlashTest() {
            // write as3 code here..
            _cam = Camera.getCamera();
            _cam.setMode(320, 240, 15);
            _vid = new Video(320, 240);
            _vid.attachCamera(_cam);
            _vid.filters = [new ConvolutionFilter(1, 3, [0, 4, -4]), new BlurFilter()];
            
            var vid2:Video = new Video(320, 240);
            vid2.attachCamera(_cam);
            vid2.scaleX = -1;
            vid2.x = 320;
            addChild(vid2);
            
            _bmpd = new BitmapData(320, 240, false);
            
            _flakes = new Array();
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            _bmpd.draw(_vid, new Matrix(-1, 0, 0, 1, _bmpd.width, 0));
            _bmpd.threshold(_bmpd, _bmpd.rect, new Point(), "<", 0x00220000, 0xFF000000, 0x00FF0000, true);
            
            var snow:Snow = new Snow();
            snow.x = Math.random() * _bmpd.width;
            addChild(snow);
            _flakes.push(snow);
            
            for(var i:int = _flakes.length - 1;i >= 0;i--)
            {
                snow = _flakes[i] as Snow;
                if(_bmpd.getPixel(snow.x, snow.y) == 0)
                {
                    snow.update();
                    if(snow.y > _bmpd.height)
                    {
                        removeChild(snow);
                        _flakes.splice(i, 1);
                    }

                }

            }

        }


    }
}
import flash.display.Sprite;

class Snow extends Sprite
{
    public var vx:Number;
    public var vy:Number;
    
    public function Snow()
    {
        graphics.beginFill(0xFFFFFF, 0.7);
        graphics.drawCircle(0, 0, 2);
        graphics.endFill();
        
        vx = 0;
        vy = 1;
    }
    
    public function update():void
    {
        vx += Math.random() * 0.2 - 0.1;
        vx *= 0.95;
        x += vx;
        y += vy;
    }


}
