/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uSu4
 */

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRata="60")]
    
    public class FlashTest extends Sprite {
        private var max:uint = 9;
        private var particles:Array = [];
        private var _container:Sprite;
        private var _canvas:BitmapData;
        private var _ctf:ColorTransform = new ColorTransform(0.985, 0.985, 0.985, 1);
        private var _pt:Point = new Point(0, 0);
        private var _blur:BlurFilter = new BlurFilter(2, 2, 1);
        private var _glow:GlowFilter = new GlowFilter(0xffffff, 0.1, 0.01, 0.01);
        public var stats:Stats = new Stats();
        
        public function FlashTest() {
            addChild(stats);
            _container = new Sprite();
            _canvas = new BitmapData(465, 465, true, 0x000000);
            addChild(new Bitmap(_canvas));
            addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(e:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            createParticle();
        }
        
        private function createParticle():void
        {
            for(var i:uint=0; i<max; i++) {
                particles[i] = new Particle(0xffffff*Math.random(), _container, (i + 1)*360/max);
            }
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        private function render(e:Event):void
        {
            for(var i:uint=0; i<max; i++) {
                particles[i].update();
            }
            _canvas.draw(_container);
            _canvas.applyFilter(_canvas, _canvas.rect, _pt, _blur);
            _canvas.colorTransform(_canvas.rect, _ctf);
            filters = [_glow];
        }
    }
}

import flash.display.Sprite;
import flash.display.DisplayObjectContainer;
import flash.display.DisplayObject;

class Particle
{
    private var _x:Number = 0;
    private var _y:Number = 0;
    private var _z:Number = 0;
    private var _color:uint = 0xffffff;
    private var _angle:Number;
    private var _r:uint = 140;
    private var _main:DisplayObjectContainer;
    private var _graphic:Sprite;
    private var _defx:uint = 232;
    private var _defy:uint = 232;
    private var _defZ:uint = 0;
    private var _rotation:Number = 0;
    private var _container:Sprite;
    
    public function Particle(color:uint, main:DisplayObjectContainer, rotation:Number)
    {
        _main = main;
        _color = color;
        _angle = Math.random()*2*Math.PI;
        _graphic = new Sprite();
        _graphic.graphics.beginFill(_color, 1);
        _graphic.graphics.drawCircle(0, 0, 3);
        _graphic.graphics.endFill();
        _container = new Sprite();
        _container.addChild(_graphic);
        _main.addChild(_container);
        _container.rotation = rotation;
        _container.x = _defx;
        _container.y = _defy;
        _container.z = _defZ;
    }
    
    public function update():void
    {
        _x = Math.cos(-_angle)*_r;
        _y = Math.sin(-_angle)*_r*1/12;
        _z = Math.sin(-_angle)*_r*1/12;
        _angle = _angle+2*Math.PI/120;
        _graphic.x = _x;
        _graphic.y = _y;
        _graphic.z = _z;
        _graphic.scaleX = _graphic.scaleY = 0.5 - Math.sin(_angle) / 2 + 0.5;
        _graphic.blendMode = "add";
        _graphic.alpha = 1;
    }

 
}
