/**
 * Copyright Seiya.Kai ( http://wonderfl.net/user/Seiya.Kai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uSqO
 */

package
{
    import flash.display.Sprite;
    [SWF(width="600",height="600",frameRate="60")]
    public class Main extends Sprite
    {
        private const WIDTH:Number = 600;
        private const HEIGHT:Number = 600;
        
        public function Main()
        {
            var s:Sprite = new Revolution(250);
            stage.addChild(s);
            s.x = WIDTH / 2;
            s.y = HEIGHT / 2;
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;

class Revolution extends Sprite
{
    private var ball:Sprite = new Sprite();
    private var circleLine:Sprite = new Sprite();
    private var xLine:Sprite = new Sprite();
    private var yLine:Sprite = new Sprite();
    private var earth:Sprite = new Sprite();
    
    private var circleSize:Number = 100;
    private var count:Number = 0;
    private var angle:Number = 0;
    
    public function Revolution(_radius:Number=100)
    {
        circleSize = _radius ;
        
        circleLine.graphics.lineStyle(2,0x000000);
        circleLine.graphics.drawCircle(0,0,circleSize);
        circleLine.graphics.endFill();
        
        earth.graphics.beginFill(0x0000FF,1.0);
        earth.graphics.drawCircle(0,0,circleSize/5);
        earth.graphics.endFill();
        
        ball.graphics.lineStyle(2,0x000000);
        ball.graphics.beginFill(0xFFFF00);
        ball.graphics.drawCircle(0,0,circleSize/10);
        ball.graphics.endFill();
        
        xLine.graphics.lineStyle(2,0x000000);
        xLine.graphics.moveTo(0,-circleSize -circleSize/4);
        xLine.graphics.lineTo(0,circleSize +circleSize/4);
        
        yLine.graphics.lineStyle(2,0x000000);
        yLine.graphics.moveTo(-circleSize -circleSize/4,0);
        yLine.graphics.lineTo(circleSize +circleSize/4,0);
        
        addChild(circleLine);
        addChild(earth);
        addChild(xLine);
        addChild(yLine);
        addChild(ball);
        
        addEventListener(Event.ENTER_FRAME,onEnterFrame);
    }
    
    private function onEnterFrame(e:Event):void
    {
        angle = count * Math.PI / 180;
        
        ball.x = Math.cos(angle) * circleSize;
        ball.y = Math.sin(angle) * circleSize;
        
        xLine.x = Math.cos(angle) * circleSize;
        yLine.y = Math.sin(angle) * circleSize;
        
        count++;
    }
}