/**
 * Copyright bigfish ( http://wonderfl.net/user/bigfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uSex
 */

// forked from bigfish's cellular automata #3
// forked from bigfish's forked from: cellular automata #1
// forked from bigfish's cellular automata #1
package {

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Rectangle;
    import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * if top + right both white --> color = left color
	 * else --> color = opposite of left color
	 */
    public class CellularAutomata4 extends Sprite {
		
		private var bmd:BitmapData;
		private var canvas:Bitmap;
		private var rows:int = 400;
		private var cols:int = 400;
		private var left:int = cols + 1;
		private var right:int = cols - 1;
		private var rect:Rectangle = new Rectangle(0, 0, cols, rows);
		private var numPixels:int = rows*cols;
		private var pixelVector:Vector.<uint> = new Vector.<uint>(numPixels);
		private const WHITE:uint = 0xFFFFFFFF;
		private const BLACK:uint = 0xFF000000;

        public function CellularAutomata4() {
            init();
        }
		/**
		 * set up canvas
		 */
		private function init():void
		{
			
			bmd = new BitmapData(cols,rows,true,WHITE);
			//seed pixel
			bmd.setPixel(200,0,BLACK);
			canvas = new Bitmap(bmd);
			canvas.x = 20;
			canvas.y = 20;
			addChild(canvas);
			iterate();
			//addEventListener(Event.ENTER_FRAME, iterate);
		}


		/**
		 * apply rule to image (one iteration)
		 */
		//private function iterate(e:Event):void
		private function iterate():void
		{
			var opposite:uint;

			pixelVector = bmd.getVector(rect);
			for(var i:int = cols; i < numPixels; ++i)
			{
					
				if(i%cols > 0 && i%cols < right){

					if(pixelVector[i - right] == WHITE  && ( pixelVector[i - cols] == WHITE)){

						pixelVector[i] = pixelVector[i - left];
					
					} else {

						pixelVector[i] = pixelVector[i - left] == WHITE ? BLACK : WHITE;
							
					}
				}


		   
			}

			bmd.setVector(rect, pixelVector);


		}



    }
}
