/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uSRT
 */

package {
	import com.bit101.components.HSlider;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	
	/**
	 * Testing projected shape behavior (and it sucks).
	 */
	[SWF(width=465,height=465,backgroundColor=0)]
	public class HTest extends Sprite {
		public var anchors:Vector.<Anchor>;
		public var homography:Homography;
		public var focal:HSlider;
		public function HTest () {
			anchors = new Vector.<Anchor> (4, true);
			addChild (anchors [0] = new Anchor (100, 257));
			addChild (anchors [1] = new Anchor (122, 218));
			addChild (anchors [2] = new Anchor (131, 251));
			addChild (anchors [3] = new Anchor (111, 296));
			addChild (homography = new Homography);
			homography.x = homography.y = 232;
			with (focal = new HSlider (this, 100, 300)) {
				minimum = 10; maximum = 10000; tick = 0.1; value = 400; width = 250;
			}
			stage.addEventListener (MouseEvent.MOUSE_MOVE, onMouseMove);
			onMouseMove (null);
		}
		public function onMouseMove (e:MouseEvent):void {
			if ((e == null) || e.buttonDown) {
				homography.update (focal.value,
					new Point (anchors [0].x, anchors [0].y),
					new Point (anchors [1].x, anchors [1].y),
					new Point (anchors [2].x, anchors [2].y),
					new Point (anchors [3].x, anchors [3].y)
				);
			}
		}
	}
}

import flash.display.Sprite;
import flash.events.MouseEvent;
class Anchor extends Sprite {
	public function Anchor (x0:int, y0:int) {
		x = x0; y = y0;
		graphics.beginFill (0xFF7F00, 1);
		graphics.drawRect (-4, -4, 8, 8);
		graphics.drawRect (-2, -2, 4, 4);
		graphics.beginFill (0xFF7F00, 0);
		graphics.drawRect (-2, -2, 4, 4);
		useHandCursor = buttonMode = true;
		addEventListener (MouseEvent.MOUSE_DOWN, startDragMe);
		addEventListener (MouseEvent.MOUSE_UP, stopDragMe);
	}
	public function startDragMe (e:MouseEvent):void {
		startDrag ();
	}
	public function stopDragMe (e:MouseEvent):void {
		stopDrag ();
	}
}

/**
 * @author zeh, original idea
 * @author makc, inverted transform
 * @see http://zehfernando.com/2010/the-best-drawplane-distortimage-method-ever/
 */
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Shape;
import flash.geom.Point;
import flash.geom.Vector3D;
class Homography extends Shape {

	public function update (focalLength:Number,
		p0:Point, p1:Point, p2:Point, p3:Point,
		halfWidth:int = 232, halfHeight:int = 232):void {

		// Find diagonals intersection point
		var pc:Point = new Point;

		var a1:Number = p2.y - p0.y;
		var b1:Number = p0.x - p2.x;
		var a2:Number = p3.y - p1.y;
		var b2:Number = p1.x - p3.x;

		var denom:Number = a1 * b2 - a2 * b1;
		if (denom == 0) {
			// something is better than nothing
			pc.x = 0.25 * (p0.x + p1.x + p2.x + p3.x);
			pc.y = 0.25 * (p0.y + p1.y + p2.y + p3.y);
		} else {
			var c1:Number = p2.x * p0.y - p0.x * p2.y;
			var c2:Number = p3.x * p1.y - p1.x * p3.y;
			pc.x = (b1 * c2 - b2 * c1) / denom;
			pc.y = (a2 * c1 - a1 * c2) / denom;
		}

		// Lengths of first diagonal
		var ll1:Number = Point.distance(p0, pc);
		var ll2:Number = Point.distance(pc, p2);

		// Lengths of second diagonal
		var lr1:Number = Point.distance(p1, pc);
		var lr2:Number = Point.distance(pc, p3);

		// Ratio between diagonals
		var f:Number = (ll1 + ll2) / (lr1 + lr2);

		var T0:Number = ll2 / f;
		var T1:Number = lr2;
		var T2:Number = ll1 / f;
		var T3:Number = lr1;

		p0.offset ( -halfWidth, -halfHeight); p0.normalize (p0.length * T0);
		p1.offset ( -halfWidth, -halfHeight); p1.normalize (p1.length * T1);
		p2.offset ( -halfWidth, -halfHeight); p2.normalize (p2.length * T2);
		p3.offset ( -halfWidth, -halfHeight); p3.normalize (p3.length * T3);

		var z0:Number = focalLength * T0;
		var z1:Number = focalLength * T1;
		var z2:Number = focalLength * T2;
		var z3:Number = focalLength * T3;

		// find any orthogonal basis in the plane
		var u:Vector3D = new Vector3D (p1.x - p0.x, p1.y - p0.y, z1 - z0);
		var v:Vector3D = new Vector3D (p1.x - p2.x, p1.y - p2.y, z1 - z2);
		var scale:Number = 200 / (u.length + v.length);
		var w:Vector3D = u.crossProduct (v); v = w.crossProduct (u);
		u.normalize (); v.normalize ();

		w.x = 0.25 * (p0.x + p1.x + p2.x + p3.x);
		w.y = 0.25 * (p0.y + p1.y + p2.y + p3.y);
		w.z = 0.25 * (z0   + z1   + z2   + z3);
		p0.x -= w.x; p0.y -= w.y; z0 -= w.z;
		p1.x -= w.x; p1.y -= w.y; z1 -= w.z;
		p2.x -= w.x; p2.y -= w.y; z2 -= w.z;
		p3.x -= w.x; p3.y -= w.y; z3 -= w.z;

		graphics.clear ();
		graphics.beginFill (0xFF0000);
		graphics.drawCircle (
			u.dotProduct (new Vector3D (p0.x, p0.y, z0)) * scale,
			v.dotProduct (new Vector3D (p0.x, p0.y, z0)) * scale,
			5
		);
		graphics.drawCircle (
			u.dotProduct (new Vector3D (p1.x, p1.y, z1)) * scale,
			v.dotProduct (new Vector3D (p1.x, p1.y, z1)) * scale,
			5
		);
		graphics.drawCircle (
			u.dotProduct (new Vector3D (p2.x, p2.y, z2)) * scale,
			v.dotProduct (new Vector3D (p2.x, p2.y, z2)) * scale,
			5
		);
		graphics.drawCircle (
			u.dotProduct (new Vector3D (p3.x, p3.y, z3)) * scale,
			v.dotProduct (new Vector3D (p3.x, p3.y, z3)) * scale,
			5
		);
	}
}