/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uRs3
 */

package
{
    import flash.events.Event;
    //import flash.events.KeyboardEvent;
    //import flash.ui.Keyboard;
    //import flash.utils.Dictionary;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.*;
    import Box2D.Dynamics.*;
    import Box2D.Collision.*;
    import Box2D.Common.Math.*;
    import org.papervision3d.lights.PointLight3D;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.view.BasicView;
    [SWF(backgroundColor="#000000", width="475", height="475")]
    public class Main extends BasicView
    {
        private var m_iterations : int;
        private var m_timeStep : Number;
        private var m_world : b2World;
        private var cubs : Array = new Array();
        private var boys : Array = new Array();
        public function Main()
        {
            var light : PointLight3D = new PointLight3D(true);
            light.z = -200;
            light.y = 300;
            m_iterations = 0.01;
            m_timeStep = 1 / 20;
            var worldAABB : b2AABB = new b2AABB;
            worldAABB.lowerBound.Set(-100.0, -100.0);
            worldAABB.upperBound.Set(100.0, 100.0);
            var gravity : b2Vec2 = new b2Vec2(0.0, -9.8);
            m_world = new b2World(worldAABB, gravity, true);
            var wallShapeDef : b2PolygonDef = new b2PolygonDef();
            var wallBodyDef : b2BodyDef = new b2BodyDef();
            var wall : b2Body;
            wallShapeDef.SetAsBox(100, 5);            
            wallBodyDef.position.Set(0, 95);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);            
            wallBodyDef.position.Set(0, 5);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            
            wallShapeDef.SetAsBox(5, 100);
            wallBodyDef.position.Set(5, 0);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);            
            wallBodyDef.position.Set(95, 0);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            
            wall.SetMassFromShapes();
            for (var i : int = 0; i < 5; i++)
            {
                var boxShape : b2PolygonDef = new b2PolygonDef();
                boxShape.SetAsBox(2, 2);
                //boxShape.density = 8;
                boxShape.friction = 8;
                boxShape.restitution = 0.5;
                var bodyDef : b2BodyDef = new b2BodyDef();
                bodyDef.position.Set(50, i * 6 + 40);
                var body : b2Body = m_world.CreateBody(bodyDef);
                body.CreateShape(boxShape);
                body.SetMassFromShapes();
            }
            var dbgDraw : b2DebugDraw = new b2DebugDraw();
            dbgDraw.m_sprite = this;
            dbgDraw.m_drawScale = 2.0;
            dbgDraw.m_fillAlpha = 0.8;
            dbgDraw.m_lineThickness = 0.3;
            dbgDraw.m_alpha = 0.3;
            dbgDraw.m_xformScale = 1.0
            dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            m_world.SetDebugDraw(dbgDraw);
            startRendering();
        } 
        override protected function onRenderTick(event : Event = null) : void
        {
            m_world.Step(m_timeStep, m_iterations);
            super.onRenderTick(event);
        }
    }
}
import flash.display.Sprite;

class Recorder extends Sprite

{

    public var frameOffset : int = 0;

    private var _px : Array;

    private var _py : Array;

    public function Recorder()

    {

        _px = new Array();

        _py = new Array();

    }

    public function save(rx : Number = NaN, ry : Number = NaN) : void

    {

        if (isNaN(rx))

        {

            _px.push(x);

            _py.push(y);

        }

        else

        {

            _px.push(rx);

            _py.push(ry);

        }

    }

    public function restore(frame : int) : void

    {

        if (frame < _px.length)

        {

            x = _px[frame];

            y = _py[frame];

        }

    }

    public function draw(color : uint, radius : Number) : void

    {

        graphics.beginFill(color);

        graphics.drawCircle(0, 0, radius);

        graphics.endFill();

    }

}



