/**
 * Copyright misinoe ( http://wonderfl.net/user/misinoe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uQuX
 */

package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    public class FlashTest extends Sprite {
        
        private var points:Array/*of Point*/ = [];
        
        public function FlashTest() {
            // write as3 code here..
            stage.addEventListener(MouseEvent.MOUSE_DOWN, stage_mouseDownHandler );
        }
        
        private function stage_mouseDownHandler( mouseEvent:MouseEvent ):void{
            points.push( new Point(mouseX, mouseY ) );
            stage.addEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMoveHandler );
            stage.addEventListener( MouseEvent.MOUSE_UP, stage_mouseUpHandler );
        }
        
        private function stage_mouseUpHandler( mouseEvent:MouseEvent ):void{
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMoveHandler );
            stage.removeEventListener( MouseEvent.MOUSE_UP, stage_mouseUpHandler );
        }
        private function stage_mouseMoveHandler( mouseEvent:MouseEvent ):void{
            points.push( new Point(mouseX,mouseY) );
            draw();
        }

        private function draw():void {
            
            graphics.lineStyle( 0 );
            
            // 点1,2,3とPrevHandleのデータを元に点1,2
            
            var prevHandlePoint:Point = new Point();
            
            var len:int = points.length;
            // trace( len );
            for ( var i:int = 2; i < len; i++ ) {
                
                // points
                var point1:Point = points[i - 2];
                var point2:Point = points[i-1];
                var point3:Point = points[i];
                
                // radian
                var rad1to2:Number = Math.atan2( point2.y - point1.y, point2.x - point1.x );
                var rad2to3:Number = Math.atan2( point3.y - point2.y, point3.x - point2.x );
                
                // 距離
                var dis1to2:Number = Point.distance( point1, point2 );
                var dis2to3:Number = Point.distance( point2, point3 );
                
                if ( rad1to2-Math.PI > rad2to3 ) {
                    rad2to3 -= Math.PI * 2;
                }
                if ( rad1to2 + Math.PI < rad2to3 ) {
                    rad2to3 += Math.PI * 2;
                }
                
                // ハンドルの角度の計算と距離の計算
                var handleRad:Number =  (rad1to2 + rad2to3) /2;
                var handleDis:Number = Math.min( dis1to2, dis2to3 );
                
                // ハンドル1の座標の計算
                var handlePoint1:Point = new Point();
                handlePoint1.x = point2.x - Math.cos( handleRad ) * handleDis;
                handlePoint1.y = point2.y - Math.sin( handleRad ) * handleDis;
                // ハンドル2の座標の計算
                var handlePoint2:Point = new Point();
                handlePoint2.x = point2.x + Math.cos( handleRad ) * handleDis;
                handlePoint2.y = point2.y + Math.sin( handleRad ) * handleDis;
                
                // グラフィックの描画
                
                graphics.moveTo( point1.x, point1.y );
                graphics.cubicCurveTo( prevHandlePoint.x, prevHandlePoint.y, handlePoint1.x, handlePoint1.y, point2.x, point2.y );
                /*
                graphics.moveTo( point1.x, point1.y );
                graphics.lineStyle( 0, 0xFF );
                graphics.lineTo( prevHandlePoint.x, prevHandlePoint.y );
                graphics.lineStyle( 0, 0xFF00 );
                graphics.lineTo( handlePoint1.x, handlePoint1.y );
                graphics.lineStyle( 0, 0xFF0000 );
                graphics.lineTo( point2.x, point2.y );
                */
                
                // ハンドルの引き継ぎ
                prevHandlePoint = handlePoint2;
                
            }
        }
    }
}