/**
 * Copyright Hiiragi ( http://wonderfl.net/user/Hiiragi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uQtj
 */

// forked from _______'s forked from: あなたのイベントハンドラを教えて！
// forked from clockmaker's あなたのイベントハンドラを教えて！
/**
 * //removeEventListenerに挑戦
 * //あんまりいいのにならなかった・・・。
 * 
* あなたのイベントハンドラを教えて！
*
* 複数のイベント＆複数のインスタンスに
* イベントハンドラを設定するときに
* みなさんの記述方法の違いを知りたい。
*
* [ルール]
* 画面上に3つのボタンが用意されており、
* クリックとロールオーバーの
* イベントハンドラを記述してください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
	import flash.utils.Dictionary;
    public class FlashTest extends Sprite {
    
        private var _btnA:MyButton;
        private var _btnB:MyButton;
        private var _btnC:MyButton;
        private var _label:MyTextField;
		
		private var _clickFunctionDictionary:Dictionary;
		private var _rollOverFunctionDictionary:Dictionary;
		
        public function FlashTest() {
            // ボタンを作成
            _build();
            
			_clickFunctionDictionary = new Dictionary();
			_rollOverFunctionDictionary = new Dictionary();
			
            // クリック
            _btnA.addEventListener(MouseEvent.CLICK, _getClickedHandler(_btnA, "A がクリックされました"));
            _btnB.addEventListener(MouseEvent.CLICK, _getClickedHandler(_btnB, "B がクリックされました"));
            _btnC.addEventListener(MouseEvent.CLICK, _getClickedHandler(_btnC, "C がクリックされました"));
            // ロールオーバー
            _btnA.addEventListener(MouseEvent.ROLL_OVER, _getRollOverHandler(_btnA, "A がロールオーバーされました"));
            _btnB.addEventListener(MouseEvent.ROLL_OVER, _getRollOverHandler(_btnB, "B がロールオーバーされました"));
            _btnC.addEventListener(MouseEvent.ROLL_OVER, _getRollOverHandler(_btnC, "C がロールオーバーされました"));
			
			
			//removeEventListener
			_btnA.removeEventListener(MouseEvent.CLICK, _clickFunctionDictionary[_btnA]);
			_btnB.removeEventListener(MouseEvent.CLICK, _clickFunctionDictionary[_btnB]);
			_btnC.removeEventListener(MouseEvent.CLICK, _clickFunctionDictionary[_btnC]);
			
			_btnA.removeEventListener(MouseEvent.ROLL_OVER, _rollOverFunctionDictionary[_btnA]);
			_btnB.removeEventListener(MouseEvent.ROLL_OVER, _rollOverFunctionDictionary[_btnB]);
			_btnC.removeEventListener(MouseEvent.ROLL_OVER, _rollOverFunctionDictionary[_btnC]);
        }
        
        private function _getClickedHandler(key:Object, message : String):Function {
			var f:Function = function(e:MouseEvent):void {
        			_label.text = message;
        		}
				
			_clickFunctionDictionary[key] = f;
        	return f
        }
        
        private function _getRollOverHandler(key:Object, message : String):Function {
			var f:Function = function(e:MouseEvent):void {
        			_label.text = message;
        		}
				
			_rollOverFunctionDictionary[key] = f;
        	return f
        }
        
        /**
        * インターフェースを作る
        */
        private function _build():void {
            _label = new MyTextField();
            _label.x = 150; _label.y = 280;
            addChild(_label);

            _btnA = new MyButton();
            _btnA.text = "Button A"; 
            _btnA.x = 70; _btnA.y = 230;
            addChild(_btnA);
            
            _btnB = new MyButton();
            _btnB.text = "Button B";
            _btnB.x = 190; _btnB.y = 230;
            addChild(_btnB);
   
            _btnC = new MyButton();            
            _btnC.text = "Button C";
            _btnC.x = 310; _btnC.y = 230;
            addChild(_btnC);
        }
    }
}

import flash.display.*
import flash.text.*;

/**
* MyButton クラスはボタン的な挙動をするようにしたSpriteです。
*/
class MyButton extends Sprite {
    private var _text:MyTextField;
    /**
    * 新しい MyButton インスタンスを作成します。
    */
    public function MyButton(){
        graphics.beginFill(0x000000);
        graphics.drawRoundRect(0, 0, 100, 30, 5, 5);
        addChild(_text = new MyTextField);
        buttonMode = true;
    }
    /**
    * ボタンの文言を設定します。
    */
    public function set text(value:String):void {
        _text.text = value;
        _text.x = (100 - _text.textWidth) / 2;
        _text.y = (30 - _text.textHeight) / 2;
    }
}

/**
* MyTextField クラスは適当な初期設定をしただけのテキストフィールドです。
*/
class MyTextField extends TextField {
    /**
    * 新しい MyTextField インスタンスを作成します。
    */
    public function MyTextField() {
        defaultTextFormat = new TextFormat("_sans", 12, 0xFF0000);
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
    }
}