/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uQQ6
 */

package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.UncaughtErrorEvent;
    import flash.system.Security;
    
    /**
     * wonderfl 2010.
     * 2010年に投稿されたコードまとめ
     * ソースがカオス
     * @author paq89
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class Main extends Sprite
    {
        private var _canvas:Sprite;
        private var _slideshow:WonderflSlideshow;
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //var g:Graphics = graphics;
            //g.beginFill(0x000000, 1);
            //g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            Wonderfl.capture_delay(10);
            
            Security.allowDomain("http://wonder-tools.appspot.com/");
            Security.allowDomain("http://swf.wonderfl.net/");
            Security.allowDomain("http://wonderfl.net/");
            
            loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, function(event:UncaughtErrorEvent):void {
                event.preventDefault();
            });
            
            _canvas = new Sprite();
            addChild(_canvas);
            
            _slideshow = new WonderflSlideshow(stage);
            _slideshow.start();
            _canvas.addChild(_slideshow)
        }
    }
    
}

import com.adobe.serialization.json.JSON;
import com.bit101.components.Label;
import com.bit101.components.PushButton;
import com.bit101.components.Style;
import flash.display.Graphics;
import flash.display.Loader;
import flash.display.Shape;
import flash.display.Sprite;
import flash.display.Stage;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.events.UncaughtErrorEvent;
import flash.net.navigateToURL;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.utils.Timer;
import mx.formatters.DateFormatter;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Sine;
import org.libspark.betweenas3.tweens.ITween;

/**
 * WonderflSlideshow はWonderfl に投稿されたコードをスライドショーで表示するためのクラスです.
 * @author paq
 */
internal class WonderflSlideshow extends Sprite
{
    private var _loaderA:WonderflLoader;
    private var _loaderB:WonderflLoader;
    private var _timer:Timer;
    private var _control:WonderflController;
    private var _url:String;
    private var _IDs:Vector.<String>;
    private var _urlRequest:URLRequest;
    private var _urlLoader:URLLoader;
    private var _count:int;
    private var _currentID:String;
    private var _stage:Stage;
    
    public function WonderflSlideshow(stage:Stage):void
    {
        _stage = stage;
        
        _count = 0;
        _IDs = new Vector.<String>();
        _urlRequest = new URLRequest();
        _urlLoader = new URLLoader();
        _urlLoader.addEventListener(Event.COMPLETE, _onComplete);
        
        _loaderA = new WonderflLoader();
        _loaderA.addEventListener(Event.COMPLETE, _onLoadComplete);
        _loaderB = new WonderflLoader();
        _loaderB.addEventListener(Event.COMPLETE, _onLoadComplete);
        addChild(_loaderA);
        addChild(_loaderB);
        
        _control = new WonderflController(_stage.stageWidth, _stage.stageHeight);
        _control.addEventListener("next", function():void {
            _timer.dispatchEvent(new TimerEvent(TimerEvent.TIMER));
        });
        _control.addEventListener("prev", function():void {
            if (_count < 2) return;
            _currentID = _IDs[_IDs.length - 2];
            _timer.reset();
            _timer.start();
            _control.url = Code.getURL(_currentID);
            _load();
        });
        addChild(_control);
        
        _timer = new Timer(7000, 1);
        _timer.addEventListener(TimerEvent.TIMER, _onTimer);
        
        _stage.addEventListener(Event.RESIZE, _onResize);
    }
    
    private function _onLoadComplete(e:Event):void
    {
        _centering();
    }
    
    private function _centering():void
    {
        //_loaderA.loader.x = (_stage.stageWidth / 2 - _loaderA.loader.width / 2) >> 0;
        //_loaderA.loader.y = (_stage.stageHeight / 2 - _loaderA.loader.height / 2) >> 0;
        //_loaderB.loader.x = (_stage.stageWidth / 2 - _loaderB.loader.width / 2) >> 0;
        //_loaderB.loader.y = (_stage.stageHeight / 2 - _loaderB.loader.height / 2) >> 0;
    }
    
    public function start():void
    {
        _timer.start();
        next();
    }
    
    public function next():void
    {
        _currentID = Code.ID[Math.random() * Code.ID.length >> 0];
        //_currentID = Code.ID[_count];
        _control.url = Code.getURL(_currentID);
        _IDs.push(_currentID);
        _load();
        _count++;
    }
    
    public function _load():void
    {
        _control.clear();
        _stageReset();
        var url:String = Code.getSWF(_currentID);
        if (_loaderA.isShowing)
        {
            _loaderA.hide();
            _loaderB.load(url);
        }
        else
        {
            _loaderB.hide();
            _loaderA.load(url);
        }
        trace(_currentID)
        _loadCodeData();
    }
    
    private function _stageReset():void
    {
        _stage.frameRate = 60;
        _stage.align = StageAlign.TOP_LEFT;
        _stage.scaleMode = StageScaleMode.NO_SCALE;
        _stage.quality = StageQuality.HIGH;
    }
    
    private function _loadCodeData():void
    {
        _urlRequest.url = Code.getCodeAPIURL(_currentID);
        _urlLoader.load(_urlRequest);
    }
    
    private function _onComplete(event:Event):void
    {
        var json:Object = JSON.decode(_urlLoader.data);
        var date:Date = new Date(json["code"]["created_date"]*1000);
        var formatter:DateFormatter = new DateFormatter();
        formatter.formatString = "YYYY/MM/DD";
        _control.show(json["code"]["title"], json["code"]["user"]["icon"], formatter.format(date));
    }
    
    private function _onTimer(event:TimerEvent):void
    {
        _timer.reset();
        _timer.start();
        next();
    }
    
    private function _onResize(event:Event):void
    {
        _control.setSize(_stage.stageWidth, _stage.stageHeight);
        _centering();
    }
}

/**
 * ...
 * @see WonderflSlideshow
 * @author paq
 */
internal class WonderflController extends Sprite
{
    private static const WORD:String = "_abcdefghijklmnopqrstuvwxyz1234567890";
    private static const WORD_LENGTH:int = WORD.length - 1;
    
    public var url:String;
    
    private var _urlRequest:URLRequest;
    
    private var _cover:Shape;
    
    private var _userIcon:Loader;
    private var _title:Label;
    private var _date:Label;
    
    private var _nextButton:PushButton;
    private var _prevButton:PushButton;
    
    private var _targetText:String;
    private var _targetTextLength:int;
    private var _textCount:int;
    private var _timer:Timer;
    
    public function WonderflController(width:int, height:int):void
    {
        Style.BUTTON_FACE = 0x000000;
        Style.BACKGROUND = 0x000000;
        Style.LABEL_TEXT = 0xFFFFFF;
        
        _urlRequest = new URLRequest();
        
        _cover = new Shape();
        var g:Graphics = _cover.graphics;
        g.beginFill(0x000000, 0.7);
        g.drawRect(0, 0, width, 20);
        addChild(_cover);
        
        _nextButton = new PushButton(this, width - 50, 0, "NEXT", function():void {
            dispatchEvent(new Event("next"));
        });
        _nextButton.width = 50;
        
        _prevButton = new PushButton(this, width - 100, 0, "PREV", function():void {
            dispatchEvent(new Event("prev"));
        });
        _prevButton.width = 50;
        
        _userIcon = new Loader();
        _userIcon.addEventListener(MouseEvent.CLICK, _onClick);
        _userIcon.contentLoaderInfo.addEventListener(Event.COMPLETE, function():void {
            _userIcon.scaleX = 0.2;
            _userIcon.scaleY = 0.2;
        });
        addChild(_userIcon);
        
        Style.embedFonts = false;
        _title = new Label(this, 25, 0, "");
        Style.embedFonts = true;
        
        _date = new Label(this, width - 170, 0, "");
        _date.alpha = 0.8;
        
        _timer = new Timer(10);
        _timer.addEventListener(TimerEvent.TIMER, _onTimer);
    }
    
    public function setSize(width:int, height:int):void
    {
        var g:Graphics = _cover.graphics;
        g.clear();
        g.beginFill(0x000000, 0.7);
        g.drawRect(0, 0, width, 20);
        
        _nextButton.x = width - 50;
        _prevButton.x = width - 100;
        
        _date.x = width - 170;
    }
    
    public function show(title:String, iconURL:String, date:String):void
    {
        _urlRequest.url = iconURL;
        _userIcon.load(_urlRequest);
        var tween:ITween = BetweenAS3.tween(_userIcon, { alpha:1 }, null, 2, Sine.easeOut);
        tween.play();
        
        _targetText = title;
        _targetTextLength = title.length;
        _textCount = 0;
        _title.text = "";
        _timer.reset();
        _timer.start();
        
        _date.text = date;
        
        BetweenAS3.tween(_date, { alpha:1 }, { alpha:0 }, 1, Sine.easeOut).play();
    }
    
    public function clear():void
    {
        var tween:ITween = BetweenAS3.tween(_userIcon, { alpha:0 }, null, 0.8, Sine.easeOut);
        tween.onComplete = function():void {
            if (_userIcon.contentLoaderInfo.bytesLoaded / _userIcon.contentLoaderInfo.bytesTotal > 100)
            {
                _userIcon.unload();
            }
        }
        tween.play();
        
        _targetText = "";
        _targetTextLength = _title.text.length;
        _textCount = 0;
        _timer.reset();
        _timer.start();
        
        BetweenAS3.tween(_date, { alpha:0 }, { alpha:1 }, 0.8, Sine.easeOut).play();
    }
    
    private function _onTimer(event:TimerEvent):void
    {
        var str:String = "";
        var i:int = 0;
        if (_targetText == "")
        {
            str = "";
            for (i = 0; i < _targetTextLength; i++)
            {
                str += WORD.charAt(Math.random() * WORD_LENGTH >> 0);
            }
            _title.text = str;
            _textCount++;
        }
        else
        {
            str = _targetText.substr(0, _textCount);
            for (i = _textCount; i < _targetTextLength; i++)
            {
                str += WORD.charAt(Math.random() * WORD_LENGTH >> 0);
            }
            _title.text = str;
            _textCount++;
        }
    }
    
    private function _onClick(event:MouseEvent):void
    {
        _urlRequest.url = url;
        navigateToURL(_urlRequest, "_blank");
    }
}

/**
 * WonderflLoader はWonderfl に投稿されたコードを読み込むためのクラスです.
 * @author paq
 */
internal class WonderflLoader extends Sprite
{
    private var _isTweening:Boolean;
    private var _isShowing:Boolean;
    public function get isShowing():Boolean { return _isShowing; }
    
    public function get loader():Loader { return _loader; }
    
    private var _context:LoaderContext;
    private var _loader:Loader;
    private var _request:URLRequest;
    
    public function WonderflLoader():void
    {
        _isShowing = false;
        _request = new URLRequest();
        _loader = new Loader();
        _context = new LoaderContext(true);
        
        _loader.visible = false;
        
        _loader.contentLoaderInfo.uncaughtErrorEvents.addEventListener(IOErrorEvent.IO_ERROR, _onIOError);
        _loader.contentLoaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, _onUncaughtError);
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onComplete);
        
        addChild(_loader);
    }
    
    private function _onComplete(e:Event):void
    {
        dispatchEvent(new Event(Event.COMPLETE));
        show();
    }
    
    public function load(url:String):void
    {
        if (url.search('http://') != -1) _request.url = url;
        else _request.url = Code.getSWF(url);
        _loader.load(_request);
    }
    
    public function show():void
    {
        if (isShowing) return;
        _isShowing = true;
        _loader.visible = true;
        var tween:ITween = BetweenAS3.tween(_loader, { alpha:1 }, { alpha:0 }, 2, Sine.easeOut);
        tween.play();
    }
    
    public function hide():void
    {
        if (!isShowing) return;
        _isShowing = false;
        var tween:ITween = BetweenAS3.tween(_loader, { alpha:0 }, null, 2, Sine.easeOut);
        tween.onComplete = function():void {
            _loader.visible = false;
            _loader.unloadAndStop();
        }
        tween.play();
    }
    
    private function _onIOError(event:IOErrorEvent):void
    {
        event.preventDefault();
    }
    
    private function _onUncaughtError(event:UncaughtErrorEvent):void
    {
        event.preventDefault();
    }
}

/**
 * Code はコードの情報を保持するためのクラスです.
 * @author paq
 */
internal class Code extends Object
{
    public static const BASE_URL:String = "http://wonderfl.net/";
    public static const API_BASE_URL:String = "http://api.wonderfl.net/";
    
    public static const ID:Array = [
        "5ayj",
        "jEGd",
        //"AmPE",
        "nJ0k",
        //"691A",
        "eQVf",
        "lpsG",
        //"2DtN", // プロファイラが残る
        "eOz4",
        "2R4z",
        "pUdA",
        "g1vz",
        "tlE3",
        //"iC1y",
        "tJ4V",
        "f24V",
        //"2KPM",
        "mkE2",
        "wu6T",
        "oziv",
        "wu8f",
        "cOz7",
        "jwqP",
        "hScA",
        "63d8",
        //"eZnB", // フリーズ
        "qKxA",
        "peA4",
        "i8zl",
        "ufqm",
        "4Ixz",
        "oKeC",
        "4E7F",
        "yTGI",
        "djIM",
        "5C5f",
        "3cWm",
        "lHqE",
        "1nCF",
        "dfse",
        "ivlx",
        "AgcS",
        "yYmV",
        "5ANZ",
        "ug7d",
        "b7zr",
        "xOAv",
        "xvq6",
        "3yRi",
        "8t8M",
        "99Ps",
        "hZGr",
        "nNx8",
        "irrg",
        "eUWi",
        "ii0R",
        //"a2sY",
        "tmdy",
        "m6uL",
        "5wVZ",
        "vhTF",
        "apfC",
        "2X31",
        "8xrd",
        "VLtC",
        "8mJx",
        "oQII",
        "yksh",
        "dOra",
        "qTwn",
        "g9Cm",
        "biJX",
        "1MhI",
        "eRwr",
        "1X06",
        "gDHS",
        "H33c",
        "61OW",
        "cZHu",
        "1uCy",
        "ktk5",
        "fVQE",
        "xOVc",
        "4u2a",
        "jH08",
        "toV4",
        "9Dsm",
        "j0Ts",
        "qlFz",
        "8ISA",
        "vM5c",
        "qqb0",
        "eL6D",
        "aeYG",
        "aGoH",
        "zUNw",
        "oC2U",
        "62Hz",
        "e2LB",
        "dQXj",
        "e9yM",
        "jYBp",
        "6Z8A",
        "aKAA",
        "tpoY",
        "aOYq",
        "6ps7",
        "a047",
        "mAan",
        "esp4",
        "A0HI",
        "ecbP",
        "zxTj",
        "3R1U",
        "dS98",
        "rqq8",
        "tITz",
        "pswv",
        "19fP",
        //"9NAw", // 要検証
        "2GS9",
        "b25i",
        "ge50",
        "vRZn",
        //"wzim", // null
        "kUyk",
        "fOqz",
        "t0ac",
        "AgON",
        "eO0C",
        "ehLi",
        "vv9m",
        "u1tP",
        "hvy2",
        "hXfg",
        "pTS6",
        "c4eR",
        "jCI0",
        "uaKO",
        "6Di1",
        "7E4t",
        "f5q4",
        "dttt",
        "xFWj",
        "p1X8",
        "9Z86",
        "nNqE",
        "RwYt",
        "cdRR",
        "1wUG",
        "gFv0",
        "tWU5",
        "2v5b",
        "9eE0",
        "jIEr",
        "6h3y",
        "k6FT",
        "ujZ5",
        "y0cw",
        "ftGu",
        "wvdi",
        "oXKr",
        "cBLj",
        "b9Ls",
        "4SAA",
        "nyGf",
        "7B9Y",
        "nRXQ",
        "2RVC",
        "bvqp",
        "i737",
        "tLIW",
        "rXE6",
        "aSKe",
        "lc1q",
        "sM3y",
        "3nmM",
        "tEp4",
        "rqJW",
        "n4OB",
        "asEN",
        "7prR",
        "xEwN",
        "zIfd",
        "wRyv",
        "5gPS",
        "yDrn",
        "3jUy",
        "9CwB",
        "f3uO",
        "1qWQ",
        "jK6D",
        "cE5u",
        "nNPo",
        "cATM",
        "qj1s",
        "gJ1O",
        "7NRD",
        "i0dL",
        "cQgU",
        "4vnu",
        "9Lit",
        "tBcH",
        "gL0G",
        "h9dR",
        "ph57",
        "vlgZ",
        "s1j5",
        "xjdM",
        "9KQy",
        "sFXf",
        "xaas",
        "9R9D",
        "2Yzr",
        "jkCr",
        "kdb3",
        "rKiz",
        "9Xx7",
        "dQaQ",
        "zvqy",
        "8muP",
        "7xwU",
        "wi2E",
        "cegt",
        "36Az",
        "8a2V",
        "gjgO",
        "gOig",
        "yyO7",
        "askf",
        "oD47",
        "5rQT",
        "qSL0",
        "dm24",
        "sxyt",
        "usCF",
        "6r6S",
        "3lDU",
        "ztPH",
        "4Wy6",
        "pUkB",
        "oI2u",
        "50I3",
        "3e9r",
        "f5eX",
        "hC7D",
        "6ytk",
        "2042",
        "3Roc",
        "uiOL",
        "vDfO",
        "6Av0",
        "ze7j",
        "ivfs",
        "z5Bs",
        "imOx",
        "cifX",
        "sI8g",
        "j3FU",
        "tJXN",
        "rgyc",
        "gNvl",
        "4VXc",
        "gZuX",
        "7Z2R",
        "axB2",
        "rwdU",
        "gqjs",
        "wvru",
        "iRc1",
        "wNSx",
        "gO2B",
        "ticj",
        "jeXJ",
        "tfsU",
        "yYR7",
        "mUhT",
        "tYnQ",
        "3gCN",
        "z3To",
        "stRB",
        "nX72",
        "mpK2",
        "436W",
        //"9nuR",
        "8V5P",
        "fb3l",
        "mrcB",
        "81Mj",
        "z28L",
        "kvkU",
        "horg",
        "dcd8",
        "kagi",
        "3abI",
        "hOho",
        "gDFa",
        "646E",
        "qvoZ",
        "DIgq",
        "f5N4",
        "8zEr",
        "nVWft",
        "vBEV",
        "dA1g",
        "aXwE",
        "dFCR",
        "rmxt",
        "gpUu",
        "mMPQ",
        "aSwW",
        "r9gL",
        "o1Wq",
        "ys87J",
        "iNy0",
        "dllp",
        "nzJB",
        "ujmT",
        "eoZQ",
        "rrle",
        "a3wQ",
        "1jYW",
        "sSGe",
        "sGB5",
        "3t2B",
        "w4YR",
        "3KVk",
        "cnZR",
        "exDI",
        "1hpl",
        "hLE7",
        "1QMC",
        "gD6k",
        "13um",
        "92Jy",
        "sfdx",
        "qwBh",
        "bZMr",
        "ntcH",
        "tj5H",
        "xKnl",
        "cXkO",
        "e5y9",
        "5QKQ",
        "9ZXf",
        "nvmc",
        "1VnB",
        "azPU",
        "4bJy",
        "sb5Q",
        "2A9V",
        "a7OA",
        "hTlh",
        "oIST",
        "5899",
        "aItp",
        "7Kt3",
        "2rWu",
        "mpJS",
        "e9Xo",
        "kZZ2",
        "mr9e",
        "uDBd",
        "mxrP",
        "czOs",
        "aS89",
        "r9iI",
        "mDrG",
        "voB0",
        "scrW",
        "3n23",
        "1NRPl",
        "10eI",
        "5kax",
        "5Kfb",
        "xlbr",
        "e0bK",
        "1OHO",
        "v4T4",
        "g2HX",
        "suNP2",
        "8oOn",
        "vAlp",
        "7ihL",
        "ppAR",
        "lmeX",
        "6vfm",
        "p6w0",
        "jB3z",
        "iZ2M",
        "bZkX",
        "w3PE",
        "wAUm",
        "mRun",
        "8Z2I",
        "mCZB",
        "wWCN",
        "1sKW",
        "pZNH",
        "pPaT",
        "ucSe",
        "cNNW",
        "thVu",
        "4gtC",
        "4ryz",
        "rjp7",
        "dhEj",
        "ibcD",
        "gtDb",
        "u9oV",
        "9CU7",
        "aXfA",
        "yEFY",
        "dF0u",
        "eMzU",
        "uRNO",
        "yb0z",
        "v0HW",
        "n4Ku",
        "v8dh",
        "qVmD",
        "kkNQ",
        "eZbi",
        "b8MH",
        "5N1L",
        "4InN",
        "rTG1",
        "o6k7",
        "xq5y",
        "hFfA",
        "5qU8",
        "vbla",
        "oxFi",
        "3kfQ",
        "ahtc",
        "jNX1",
        "olZB",
        "x9a3",
        "dUXf",
        "eEtL",
        "9BaG",
        "ev9L",
        "fz1TR",
        "fQu8",
        "dbrQ",
        "kpEf",
        "2F0r",
        "vMFv",
        "isiH",
        "5ZCv",
        "84iA",
        "p2KD",
        "njap",
        "s21T",
        "qSFM",
        "A0c5",
        "clRU",
        "kYyY",
        "pPk3",
        "gpms",
        "zvod",
        "o1Kx",
        "mG1x",
        "lZNa"];
    
    public static const SWF_URL:Object = {
        "h9dR": "7/78/782f/782fdf7b15f9802b9e68821f74bbada807da6f0e",
        "suNP2": "c7b84650e9ccac565f3c0c52f2ff514c979d9180",
        "10eI": "0/07/0709/07090b8fac1db916defb615be06df203a5c1293e",
        "13um": "0/07/0767/076728f33afbdda4449d7fe41e239c1e99d02de8",
        "1QMC": "0/0c/0cf9/0cf9a8ba845e9e5e6a80237786006d8e99f97ab0",
        "1VnB": "0/0d/0d7e/0d7ead209ab0b26003911be87c37f39a55475e5b",
        "1qWQ": "0/0a/0a0e/0a0e084fdbd7df50944ffd90fa3c066e284fe22e",
        "2042": "0/0e/0e06/0e063c76ca73c9772bfeec778cb03972950a6c12",
        "2A9V": "1/12/121a/121ac24efa226ab6fadaacc2ab64645d6a5a51b2",
        "2F0r": "1/12/12a7/12a706f221169a1fb0c6b0bd3d82b8e496964eec",
        "2X31": "1/14/14b1/14b11e39b9508da96c2347161d601d3fa76d0670",
        "2v5b": "1/11/1187/1187da7b6ba593a7382994fc6ff6ccfa6dc0e334",
        "3Roc": "1/1b/1b0f/1b0f8d0bdf80d95510bd8a31d205bd876e232064",
        "436W": "1/1c/1c62/1c62bfafc56de43dc7e365e9a85d4cdb325e00cc",
        "4vnu": "1/1f/1f94/1f94be90b32c6aeccb57b13efba115fc68fb010a",
        "5Kfb": "2/28/2845/28451efa3182e7a18f24c58b7ab21c5cccdc5f43",
        "5QKQ": "2/29/2901/290185dac922044d9ca16aa82498b3bfea783e94",
        "5kax": "2/25/2552/25528e1114fb6eea9ee850cbc32f901749da3beb",
        "5qU8": "2/26/2615/261577d9dd93af03da2421db6285d425aef0fb9f",
        "691A": "2/2b/2b12/2b123b8aeb5e81d83269df6ed4136f07c607817d",
        "6Z8A": "3/30/30f6/30f64a32af82b0e351be56946125de0b1b2846ea",
        "6ytk": "2/2d/2df2/2df2a340e092c7408abfee0963afc09c683b5133",
        "7B9Y": "3/35/3542/3542969b07e9c42b931e67cc49dd7f947a8373eb",
        "7NRD": "3/36/36b2/36b23a41e34d86bedb8ce5aaed33c826bb4bd763",
        "7prR": "3/33/33ef/33efad88785be28366094aed6367d10cb1368255",
        "84iA": "3/38/388d/388dd1b0e4d4daa6fa8d8a09dc457fcd5e9149fc",
        "8t8M": "3/3b/3b5c/3b5cb2c5b67d41149868613fff703f9b07d213ee",
        "9eE0": "4/40/40bb/40bb5f415f89f780a3fbc31a2678766aa853c7dd",
        "AgcS": "f/fe/fe23/fe2348b4a5be9261cb3f42446e0319fc10365417",
        "H33c": "0/04/04dd/04ddc553d63c4c97d956f19f399ed1ad8757c978",
        "a047": "4/46/4617/4617a99d63602525f710cde4de5473535293ed37",
        "aGoH": "4/4a/4ae0/4ae0aca197dbc2b7cc375105d20b33a9799e4819",
        "aItp": "4/4b/4b1c/4b1cbffa00cfc9465bd615aa12b299436d30c73d",
        "aXfA": "4/4c/4cc8/4cc8605fb1390413891f678d0cd567fae9ada1b9",
        "ahtc": "4/48/480f/480f519fa141a424700fb194480682c1d9688e37",
        "b7zr": "4/4d/4df3/4df306394226cae6c0df28a6ec48925c97e50312",
        "b9Ls": "4/4e/4e32/4e328267d617cfe53e4ff7bb1c2f6068d1495732",
        "biJX": "4/4f/4f36/4f3641b79c4ef175e059b28ef102a897780f452b",
        "cE5u": "5/58/58a2/58a22ead66b06b75ca683b3cecc9eb44e31bb330",
        "cZHu": "5/5b/5b13/5b13a072e0465ab18026cb8693c569ba132737b2",
        "cegt": "5/55/55b6/55b6ea11dd182dbebe10ef01e409008fb8fa521f",
        "cifX": "5/56/562a/562a6ddf665a15e8b438313d873c138fc028439e",
        "dFCR": "5/5f/5fd0/5fd0de7fad1f25d2bf3512792db85d1174cd44fc",
        "dUXf": "6/61/618c/618c76114a5c158496d0ede3d97e4d6bbaf447f7",
        "e5y9": "6/62/62bf/62bf116acbb9c317740b667d8cff07f1f9a9e746",
        "eRwr": "6/68/682b/682b4e7c668758b3d163e89ff3179c12fc94216b",
        "eoZQ": "6/64/64f1/64f1d3342a2a4b51611370eebb6f47b089af24a8",
        "esp4": "6/65/6554/655468e25baa8101169eeec9a03d19cefd7ea60d",
        "ev9L": "6/65/65a4/65a415997943d3f0047250a8416bc9982c075f9e",
        "f3uO": "6/69/6985/6985cefc26f6fa12b2da2487ddaa708b5e52408f",
        "f5eX": "6/69/69b8/69b847a3758ac7a66df4b9fcd641da6259e75c50",
        "gDHS": "7/74/749f/749fdbd846f8da80081f68d834183801567b1f0a",
        "gFv0": "7/74/74d3/74d3bab0ab20e07718ef059909bacff6932239ce",
        "gqjs": "7/73/731c/731c429950a65345afe7c4284c3a24af5bf22897",
        "h9dR": "7/78/782f/782fdf7b15f9802b9e68821f74bbada807da6f0e",
        "hC7D": "7/7b/7b74/7b742cda0fc38c6fe4397b7d4028d48c497ef219",
        "hFfA": "7/7b/7bce/7bceb352f0fe93660df800c2eec2d27c9e6e19e8",
        "hZGr": "7/7e/7e1e/7e1e0156e06b138590c2b8b98841e997236a7b67",
        "horg": "7/79/79e8/79e8343a2c4353a9f7d350667cc5e9008e55135a",
        "i0dL": "7/7e/7e2d/7e2d8dbaa3d6ea1f70df020110bce8fbd4bcc0d8",
        "iNy0": "8/83/83c0/83c0fa8eb9e85ce32eccd202190d426f98a22cde",
        "isiH": "8/81/815a/815a222e09fa04137aae0d60e20f0b67e111f7f3",
        "ivlx": "8/81/81b2/81b244d6ac96be37ccb4b0368cefaaef32c112f6",
        "j3FU": "8/85/8593/8593ae03c7f8c152542ef1668fcaa1a867460d8b",
        "jCI0": "8/89/8989/898980cb5e16ada8d1909eb8aa32e677696fc10b",
        "jeXJ": "8/86/86da/86da523fc325919b10bc17ea764decdcd66846c5",
        "kYyY": "9/93/9304/93041a22dc843a83f0397dbb8153260a8b788505",
        "kagi": "8/8d/8d54/8d5478d84adea1f4bf8ed774a8620e4bf82d8adf",
        "kpEf": "8/8f/8f11/8f11b887a5034c3420af0cb536119dda7df118f7",
        "kvkU": "8/8f/8fb6/8fb653a010477e5c9bbcbfc1e9caf940ec1ebcb4",
        "lZNa": "9/9a/9a29/9a29d60dbfb56349baf10f356f30d0005c3f5085",
        "mAan": "9/9e/9e46/9e46742d90447e0e9481ed5eb3b4a630794e501a",
        "mCZB": "0/02/028e/028ed7b1a901678e56e935368d78d5e5f07ae71e",
        "n4Ku": "a/a1/a1bb/a1bb74adddd5e32fa8ecef16c3048079b3c623f7",
        "nNPo": "a/a6/a6d3/a6d3f7f8bac1ee274ddc0febba8736e63441bc52",
        "nNqE": "a/a6/a6c8/a6c86acdf581a562f12b0863a0c6f434cf6a28c3",
        "ntcH": "a/a4/a47f/a47f232ea7547b6ffefb4ca96667744b56ea70d6",
        "o1Wq": "a/a8/a86c/a86c62dab31a18f261e229d0ed0ec614d3901e53",
        "oIST": "a/ad/ad47/ad471589e8a194a4a174030123642a7af278f99f",
        "p2KD": "a/af/af85/af85fd715b58a5346e2c1477f8a98c720ed3a6c1",
        "pPk3": "b/b5/b503/b5038fca421db14d6818783ca5a99a8d56473cc8",
        "qSL0": "b/bc/bc69/bc69229a3197e3e2e59493a1686c5299007a47e8",
        "qTwn": "b/bc/bc7f/bc7f3d9b6c859128e6c0d944c50c0451de0e3067",
        "qwBh": "b/b9/b9e7/b9e7f3e1cb4115ff3a6ddf535f80b41bd49da970",
        "r9gL": "b/be/be46/be46f8594533cc42e2e1f010ee0441e229fd8d05",
        "r9iI": "b/be/be47/be47e174b951ed734ea1afeacfb460ab40c428dd",
        "rKiz": "c/c2/c276/c27687adbe0dc87f6a4551884f00e30cd8b31e98",
        "rjp7": "b/bf/bf6c/bf6c40e6e929ea210ff1ce10a45cf03e8135a620",
        "rqq8": "c/c0/c037/c0374b63fe8a54d91a22623ea28f1a648f6a7e23",
        "sFXf": "c/c8/c8fa/c8faffcb70cdb5a88de6cffaf5e241a5732bd039",
        "sI8g": "c/c9/c93a/c93a0375b8b1d06e41d86ee4c4fd530d1690e582",
        "sb5Q": "c/c5/c57d/c57dec49e63e0f2dc31c53cda2cc95ee47ac8661",
        "scrW": "c/c5/c5a5/c5a52c3d1d7190e4b94021efe375021363957913",
        "suNP2": "c/c7/c7b8/c7b84650e9ccac565f3c0c52f2ff514c979d9180",
        "ug7d": "d/d4/d413/d4139a677afee692d01a7c544f80020dd5999b18",
        "ujmT": "d/d4/d471/d471bac28a6c22bde879f8791f0e5706c1e74a40",
        //"v8dh": "d/da/da31/da311a0c916a0e01f9751306d5ca9b68898dde78",
        "vDfO": "d/dd/ddb3/ddb35d48520c1546c57d445c92f37f70454030ad",
        "vMFv": "d/de/dec3/dec3cd21891e0b9c1a6b259b3148563f0b5b0899",
        "vlgZ": "d/db/dbab/dbab0810a5b44144068db197ac2b2d5198ed028e",
        "voB0": "d/dc/dc0b/dc0b2f8621af9580b21ad0d4edad29a5b4362808",
        "vv9m": "d/dc/dcc8/dcc8d9f654b5ad690395a7b8d14c9f41699bff9b",
        "wAUm": "e/e4/e471/e471a70566208fa666e75b95ad657327017dcf56",
        "wi2E": "e/e2/e24f/e24fb291f64badb60b79accf7ee63ad344f15a2e",
        "xEwN": "e/eb/ebdc/ebdc95141142e41f1a067017bf1f50bea8447b70",
        "xFWj": "e/ec/ec05/ec056d331ba11f3d66eafcd2d72f7e4542811b48",
        "xaas": "e/e8/e86e/e86e00a637063594ac8bb9522bed29754acd339d",
        "yTGI": "f/f4/f495/f495755b62fd9ce76ee343189c18dd0a4df57d21",
        "yYmV": "f/f5/f51c/f51cea267977882fdb24427de342cc89cf241172",
        "yb0z": "e/ef/ef88/ef8881b37db74fc93e06d207e4ff426bfce0cc48",
        "yksh": "f/f0/f099/f099e27a504311d240c92dac9fed4937ae38ffa0",
        "dcd8": "5/5c/5c7d/5c7da669d1076aa8df2b8515a5332f20055f0559"
    };
    
    public static function getURLByNumber(num:int):String
    {
        return BASE_URL + "c/" + ID[num];
    }
    
    public static function getURL(id:String):String
    {
        return BASE_URL + "c/" + id;
    }

    public static function getCodeAPIURL(id:String):String
    {
        return API_BASE_URL + "code/" + id + "/?api_key=" + Config.API_KEY;
    }
    
    public static function getCodeAPIByNumber(num:int):String
    {
        return API_BASE_URL + "code/" + ID[num] + "/?api_key=" + Config.API_KEY;
    }
    
    public static function getRandom():String
    {
        return ID[Math.random()*ID.length >> 0]
    }

    public static function getSWF(id:String):String
    {
        if (SWF_URL[id]) return "http://swf.wonderfl.net/swf/usercode/" + SWF_URL[id] + ".swf";
        return "http://wonder-tools.appspot.com/static/2010/swf/Code" + id + ".swf";
    }
    
    //public static function getSWFByNumber(num:int):String
    //{
        //if (SWF_URL[ID[num]]) return "http://swf.wonderfl.net/swf/usercode/" + SWF_URL[ID[num]] + ".swf";
        //return "http://wonder-tools.appspot.com/static/2010/swf/Code" + ID[num] + ".swf";
    //}
}

internal class Config extends Object
{
    public static const API_KEY:String = "efc018703b01988a0df461f83015a7cee1115c25";
}

/*
使わせていただいたコード。
使ってないコードもあるかもしれないけど、調べるのも面倒。

敬称略。順不同。
Hakuhin 描画結果を次のフレームに重ねるブラー
http://wonderfl.net/c/19fP
makc3d Twin towers (no planes :)
http://wonderfl.net/c/1MhI
watanabe 使徒襲来
http://wonderfl.net/c/1NRPl
KoheiTAKAMIYA FanLoader
http://wonderfl.net/c/1OHO
shapevent QuickBox2D Unicycler
http://wonderfl.net/c/1X06
yd_niku Sound Star 3D
http://wonderfl.net/c/1hpl
Albert forked from: Tree - ContextFreeArtAS3
http://wonderfl.net/c/1jYW
utabi Happy Tiger Year 2010
http://wonderfl.net/c/1nCF
beginners_high forked from: Wonderfl Tower Defense
http://wonderfl.net/c/1sKW
umhr 003b:アップルグリフ
http://wonderfl.net/c/1uCy
Nyarineko ゆらゆらリボン
http://wonderfl.net/c/1wUG
narutohyper Alternativa3D ファイアーボール　Sprite3Dのネストによる軌道表現 連射Ver
http://wonderfl.net/c/2DtN
narutohyper Twitter Friend Location
http://wonderfl.net/c/2GS9
umhr following viewer
http://wonderfl.net/c/2KPM
narutohyper Alternativa3D next one
http://wonderfl.net/c/2R4z
glasses_factory forked from: ribbon test
http://wonderfl.net/c/2RVC
tencho Ants
http://wonderfl.net/c/2Yzr
kuma360 砂ゲー
http://wonderfl.net/c/2rWu
yd_niku Test that uses Face.com
http://wonderfl.net/c/36Az
sekiryou 七夕：短冊 Twitter tanzaku Viewer
http://wonderfl.net/c/3KVk
termat レイトレーシング
http://wonderfl.net/c/3R1U
sakusan393 VJ風にしてみた forked from: モアレっぽい感じ
http://wonderfl.net/c/3abI
ongaeshi AS3のリファレンスマニュアルをサジェスト機能付きで検索
http://wonderfl.net/c/3cWm
ProjectNya Wavelet
http://wonderfl.net/c/3e9r
hacker_johiroshi 大学人生テトリスβ版(ver.0.3.6)
http://wonderfl.net/c/3gCN
ABA SslbParser
http://wonderfl.net/c/3jUy
keim_at_Si Active Sonar Sequencer
http://wonderfl.net/c/3kfQ
ProjectNya DotLight [Blue]
http://wonderfl.net/c/3lDU
ProjectNya ツリー形式のメニュー
http://wonderfl.net/c/3n23
yonatan wonderflで3D 【Phong shading + reflection map】
http://wonderfl.net/c/3nmM
hycro IK Test
http://wonderfl.net/c/3t2B
maccyan 飛行機っていうか、戦闘機。
http://wonderfl.net/c/4E7F
sakef 簡単ドット地球儀
http://wonderfl.net/c/4InN
narutohyper Alternativa3D Tips 読み込んだ、3DSモデルの中身を操作する
http://wonderfl.net/c/4Ixz
poiasd 2次ベジェ曲線とボールの衝突判定
http://wonderfl.net/c/4SAA
kaikoga Mine Sweeper Blitz
http://wonderfl.net/c/4VXc
ProjectNya LightTune (1)
http://wonderfl.net/c/4Wy6
tjoen FluperTruper
http://wonderfl.net/c/4bJy
Miki_vanilla Blue Cascade
http://wonderfl.net/c/4gtC
narutohyper One Man's Dream (Event's Button)
http://wonderfl.net/c/4ryz
clockmaker ♥  (Fork Step 4/4)
http://wonderfl.net/c/4u2a
jozefchutka Pixel Bender Displacement Map Fakes 3D Effect + Depth Of Field
http://wonderfl.net/c/50I3
mrgrotesque FireWorks
http://wonderfl.net/c/5899
nitoyon Perfect Shuffle Visualization 2
http://wonderfl.net/c/5ANZ
a24 Anaglyph
http://wonderfl.net/c/5C5f
mousepancyo Particle Light（StarDust）
http://wonderfl.net/c/5N1L
daijimachine Dancing Dobuemon
http://wonderfl.net/c/5ZCv
sekiryou [etude] Native3D
http://wonderfl.net/c/5ayj
makc3d I can see my house from there!
http://wonderfl.net/c/5gPS
Nyarineko 衝突判定の学習
http://wonderfl.net/c/5rQT
uwi 追尾カメラ
http://wonderfl.net/c/5wVZ
o8que ドット絵エディタ（マップエディタメーカー）
http://wonderfl.net/c/61OW
undo 落ち着け・・・素数を数えて落ち着くんだ・・・
http://wonderfl.net/c/62Hz
abakane LEGO
http://wonderfl.net/c/63d8
cpu_t SorcerersFinger - 魔法使いの指
http://wonderfl.net/c/646E
clockmaker BetweenAS3 Custom Easing Generator
http://wonderfl.net/c/6Av0
Hasufel Space Comet
http://wonderfl.net/c/6Di1
Aquioux 何でもスーラ -Seurat anything-
http://wonderfl.net/c/6h3y
jozefchutka Pixel Bender Displacement Map Fakes 3D Effect
http://wonderfl.net/c/6r6S
ProjectNya LightBlink + SoundMixer
http://wonderfl.net/c/6vfm
narutohyper Alternativa3D Tips Reflection
http://wonderfl.net/c/7E4t
mousepancyo 誕生・消滅・再生といった感じ
http://wonderfl.net/c/7Kt3
sekiryou [motif]燕子花図
http://wonderfl.net/c/7Z2R
shohei909 ぼよんぼよんテスト
http://wonderfl.net/c/7ihL
imajuk OceanCurve
http://wonderfl.net/c/7xwU
daniwell Text To Speech(Google API) - Change Speed
http://wonderfl.net/c/81Mj
fumix NoFlashSeal（他意はありません）
http://wonderfl.net/c/8ISA
hycro 妄撮メソッド
http://wonderfl.net/c/8V5P
mousepancyo ビリビリ（Lightning Effect）
http://wonderfl.net/c/8Z2I
imajuk On Curves
http://wonderfl.net/c/8a2V
mash QuickBox2D sample
http://wonderfl.net/c/8mJx
Nyarineko 四畳半神話大系的な何か
http://wonderfl.net/c/8muP
KoheiTAKAMIYA 画像を切り抜く範囲（とりあえず保存できる）
http://wonderfl.net/c/8oOn
flashrod Cart
http://wonderfl.net/c/8xrd
_ueueueueue 事故 forked from: DotLight [Tornado]
http://wonderfl.net/c/8zEr
ProjectNya LightFolium + SoundMixer
http://wonderfl.net/c/92Jy
GARENA123 Alternativa3D 7.5 でアクションゲームサンプル
http://wonderfl.net/c/9BaG
motikawa_rgm IK Test(Sliver Chain)
http://wonderfl.net/c/9CU7
set0 蝿
http://wonderfl.net/c/9CwB
TNKHRYK ワンダフルクエスト【倉庫番】
http://wonderfl.net/c/9Dsm
civet Tree in the breeze
http://wonderfl.net/c/9KQy
uwi Aqua Typography
http://wonderfl.net/c/9Lit
Aquioux 葉序開度 - Divergence of Phyllotaxy -
http://wonderfl.net/c/9NAw
alumican_net [Study] Hydrodynamics
http://wonderfl.net/c/9R9D
keim_at_Si SiON SoundObject Quartet
http://wonderfl.net/c/9Xx7
keim_at_Si FlashTextEngine の真価 f.f.: FTE（FlashTextEngine）を使ってみる on 2010-1-29
http://wonderfl.net/c/9Z86
buccchi MuscleClock
http://wonderfl.net/c/9ZXf
matsu4512 Colorful Spring Particle
http://wonderfl.net/c/9nuR
matsu4512 StarDust
http://wonderfl.net/c/A0HI
clockmaker [JigLibFlash] Meteor
http://wonderfl.net/c/A0c5
mi_ku Audio Color Cubes Visualiser
http://wonderfl.net/c/AgON
Ctrl Distorted Sex Transmissions
http://wonderfl.net/c/AmPE
alumican_net FlipText Generator
http://wonderfl.net/c/DIgq
makc3d Mycelium
http://wonderfl.net/c/RwYt
uwi forked from: レインボーロード！  forked from: nengafl
http://wonderfl.net/c/VLtC
_ueueueueue forked from: soundtest6
http://wonderfl.net/c/a3wQ
romatica curveToで道を進んでる感じ
http://wonderfl.net/c/a7OA
narutohyper Alternativa3D TextureEnvironmentMaterial （環境マップ）のテスト
http://wonderfl.net/c/aKAA
mex_takagi forked from: 【AS100本ノック】11回目：ろうそく
http://wonderfl.net/c/aOYq
kamipoo Equalizer3D
http://wonderfl.net/c/aS89
Nyarineko 【PV3D】Line3Dで遊んでみた
http://wonderfl.net/c/aSKe
clockmaker UI like Flash CS5
http://wonderfl.net/c/aSwW
tjoen Flower Power
http://wonderfl.net/c/aXwE
narutohyper noFlashSeal（偽物）
http://wonderfl.net/c/aeYG
nutsu Bezier force
http://wonderfl.net/c/asEN
ProjectNya Water in Ball
http://wonderfl.net/c/askf
ProjectNya DotLight [Color]
http://wonderfl.net/c/axB2
enok Golden Spiral
http://wonderfl.net/c/azPU
buccchi オッス、おらロク！（墨エフェクト）
http://wonderfl.net/c/b25i
Mushus くりおねてきなにか
http://wonderfl.net/c/b8MH
hycro Dot Plot
http://wonderfl.net/c/bZMr
ProjectNya 日食？ [BitmapData.applyFilter版]
http://wonderfl.net/c/bZkX
clockmaker [Math] Integral Simulation
http://wonderfl.net/c/bvqp
Kay 平面に描いた線を3D化（暫定Ver）
http://wonderfl.net/c/c4eR
clockmaker [PV3D] Depth of Field
http://wonderfl.net/c/cATM
narutohyper SpringCamera(Controller )[Alternativa3D 5.6]
http://wonderfl.net/c/cBLj
Hasufel Lemmings Follow Terrain
http://wonderfl.net/c/cNNW
Nyarineko 円グラフとスライドバー
http://wonderfl.net/c/cOz7
flex_axis Arc editing control
http://wonderfl.net/c/cQgU
Saqoosha Pixels
http://wonderfl.net/c/cXkO
zonnbe explosion with bumpmapping
http://wonderfl.net/c/clRU
Aquioux Code P.4.3.1.01 (Generative Gestaltung)
http://wonderfl.net/c/cnZR
kawamura ベジェ曲線上を等速で走る文字列
http://wonderfl.net/c/czOs
Aquioux Pattern Sketch 001
http://wonderfl.net/c/dA1g
buccchi Gamefl Life
http://wonderfl.net/c/dF0u
fumix なんか虫みたいなの
http://wonderfl.net/c/dOra
o8que 朝青龍ゲーム
http://wonderfl.net/c/dQXj
ABA SKI GAME
http://wonderfl.net/c/dQaQ
Hakuhin 手書き波形でサウンド再生
http://wonderfl.net/c/dS98
jozefchutka Penice (pen-nice)
http://wonderfl.net/c/dbrQ
Nao_u 反応拡散系のシミュレーション
http://wonderfl.net/c/dfse
nemu90kWw Garbage TETRIS
http://wonderfl.net/c/dhEj
Ctrl Alternativa3D, Billete
http://wonderfl.net/c/djIM
gaina soundtest6
http://wonderfl.net/c/dllp
ProjectNya Firefly3D
http://wonderfl.net/c/dm24
ProjectNya Aquarium (2)
http://wonderfl.net/c/e0bK
o8que Dijkstra Particle Streams
http://wonderfl.net/c/e2LB
Dorara three leaf clover
http://wonderfl.net/c/e9Xo
matsumos 某Pad
http://wonderfl.net/c/e9yM
GARENA123 Alternativa3D 7.5でBoxを飛ばしてみた。
http://wonderfl.net/c/eEtL
sakef リンゴもどき
http://wonderfl.net/c/eL6D
keim_at_Si Extended ColorChooser
http://wonderfl.net/c/eMzU
umhr FukidashiBalloon
http://wonderfl.net/c/eO0C
matsumos エセ3Dモデラー
http://wonderfl.net/c/eOz4
k__ spectrum - spiral
http://wonderfl.net/c/eQVf
tencho [Alternativa3D 7.5] test
http://wonderfl.net/c/eZbi
keim_at_Si MIDIシーケンスを演奏してみた
http://wonderfl.net/c/eZnB
narutohyper カメラの前で体を動かしたら、箱が動く・・・みたいな実験
http://wonderfl.net/c/ehLi
yd_niku Sound Star
http://wonderfl.net/c/exDI
coppieee 新技術と12人の英雄たち
http://wonderfl.net/c/f24V
horned Light Burst forked from: Shining Text
http://wonderfl.net/c/f5N4
Test_Dept Legacy Display
http://wonderfl.net/c/fOqz
kawamura ボールが弾む表現 forked from: ぼんよよよ〜ん forked from: spring ball
http://wonderfl.net/c/fQu8
nitoyon Dijkstra Visualization
http://wonderfl.net/c/fVQE
_ueueueueue forked from: Colorful Spring Particle
http://wonderfl.net/c/fb3l
matsu4512 Shooting star on the attractor road
http://wonderfl.net/c/ftGu
GARENA123 Alternativa3D 7.5で動くダンボー
http://wonderfl.net/c/fz1TR
clockmaker Queen and Manservant -女王様と下僕-
http://wonderfl.net/c/g1vz
ProjectNya TransitFlare
http://wonderfl.net/c/g2HX
keim_at_Si Explosion Rendering
http://wonderfl.net/c/g9Cm
alumican_net Embedded PixelBender Generator
http://wonderfl.net/c/gD6k
sion0303 3D Lissajous Curve
http://wonderfl.net/c/gJ1O
dubfrog 【Away3d-Lite】 CubeDivision
http://wonderfl.net/c/gL0G
wetcradle forked from: ドット地形
http://wonderfl.net/c/gO2B
ProjectNya FireTest
http://wonderfl.net/c/gOig
Aquioux サインカーブによる RGB カラーの循環変化
http://wonderfl.net/c/gZuX
o8que Juggle Them!! （ジャグれ！！）
http://wonderfl.net/c/ge50
ProjectNya DotLight [Red]
http://wonderfl.net/c/gjgO
alumican_net Whitespace Interpreter
http://wonderfl.net/c/gpUu
IPFix 3d Frame
http://wonderfl.net/c/gpms
matsu4512 MouseBeat
http://wonderfl.net/c/gtDb
shohei909 Mountain
http://wonderfl.net/c/hLE7
ProjectNya ひよこちゃん 球体の上でゆらゆら
http://wonderfl.net/c/hOho
clockmaker [Alternativa3D] Wonderfl Quest 3D
http://wonderfl.net/c/hScA
clockmaker Spiral Particles
http://wonderfl.net/c/hTlh
Kay Shining Text
http://wonderfl.net/c/hXfg
hatiya123 Box2D Clock
http://wonderfl.net/c/i737
beinteractive 自動新技術化アルゴリズムになる予定だった何か
http://wonderfl.net/c/i8zl
feb19 Tweener で 15 パズル forked from: nengafl
http://wonderfl.net/c/iC1y
ProjectNya ドットひよこ
http://wonderfl.net/c/iRc1
ProjectNya DisplacementMapFilter + PerlinNoise (2)
http://wonderfl.net/c/iZ2M
Nyarineko ImageSelectCursor
http://wonderfl.net/c/ibcD
narutohyper Alternativa3D text3D
http://wonderfl.net/c/ii0R
NetsutetsuB パーティクル崩し - RUSH
http://wonderfl.net/c/irrg
umhr 凸面の閉路
http://wonderfl.net/c/ivfs
paq [Stardust] + [Alternativa3D]
http://wonderfl.net/c/j0Ts
ProjectNya TransitPhoto [Flickr]
http://wonderfl.net/c/jB3z
sekiryou forked from: Checkmate Vol.6 Amatuer
http://wonderfl.net/c/jEGd
imajuk FireFlyEffect
http://wonderfl.net/c/jH08
nitoyon Donut shaped 360 degree photo (panorama photo) converter
http://wonderfl.net/c/jIEr
AtuyL きまぐれ作曲機 - forked from: Instrument
http://wonderfl.net/c/jNX1
narutohyper Alternativa3D and box2D = simple kaleidoscope
http://wonderfl.net/c/jYBp
shapevent Mouse Toy
http://wonderfl.net/c/jkCr
o8que Enter the world of ... (あなたがiPadを購入すべきでない唯一の理由)
http://wonderfl.net/c/kUyk
romatica 四角くて甘いもの
http://wonderfl.net/c/kZZ2
talte 1st person view  forked from: ワンダフルワールド
http://wonderfl.net/c/kdb3
Thy Graph 1.65
http://wonderfl.net/c/kkNQ
nitoyon A* Visualization
http://wonderfl.net/c/ktk5
uwi BetweenAS3だけで花火っぽいの
http://wonderfl.net/c/lHqE
narutohyper cat voice keyboard
http://wonderfl.net/c/lc1q
matsu4512 Photo Breakout
http://wonderfl.net/c/lmeX
buccchi up to you
http://wonderfl.net/c/lpsG
o8que ワンダフルワールド
http://wonderfl.net/c/m6uL
ProjectNya Fireworks +  SoundMixer
http://wonderfl.net/c/mDrG
whaison forked from: [PV3D] Refrection Cube - Gradation Version
http://wonderfl.net/c/mG1x
ProjectNya Flare
http://wonderfl.net/c/mMPQ
fumix MOTION BLUR DEMO 001 (PV3D)
http://wonderfl.net/c/mRun
tencho Shadow
http://wonderfl.net/c/mUhT
narutohyper Alternativa3D 3Dスロット
http://wonderfl.net/c/mkE2
kamipoo HUWAHUWA LINE
http://wonderfl.net/c/mpJS
sakef simple 3D 02 (not using PV3D)
http://wonderfl.net/c/mpK2
kuma360 綺麗なキューブ
http://wonderfl.net/c/mr9e
uwi Rainbow Tube
http://wonderfl.net/c/mrcB
romatica 風に揺れる葉
http://wonderfl.net/c/mxrP
whirlpower IK Fiber
http://wonderfl.net/c/n4OB
clockmaker [Stardust] Particle on Mouse Position
http://wonderfl.net/c/nJ0k
tencho Water Caustics
http://wonderfl.net/c/nVWft
tencho moja race
http://wonderfl.net/c/njap
o8que Wonderfl Tower Defense
http://wonderfl.net/c/nvmc
shinano_cake_koubou 2点透視図法で描く立方体
http://wonderfl.net/c/nyGf
zonnbe soundSpectrumCity
http://wonderfl.net/c/o6k7
umroom ファンネル(ビット)wonderfl移植
http://wonderfl.net/c/oC2U
hogemaruo 火炎放射。
http://wonderfl.net/c/oD47
rsakane ワンダフルクエスト(不思議のダンジョン風に)
http://wonderfl.net/c/oKeC
sakef レインボーロード！  forked from: nengafl
http://wonderfl.net/c/oQII
clockmaker Dumping Graphics
http://wonderfl.net/c/oXKr
keim_at_Si にょきにょきシンセサイザー(Hex-cylindrical arpeggiator)
http://wonderfl.net/c/olZB
zendenmushi Rainbow beetle  with Alternativa3D
http://wonderfl.net/c/oxFi
matsumos ニコニコ動画で見たアレの劣化版
http://wonderfl.net/c/oziv
rsakane トランジション
http://wonderfl.net/c/p1X8
ProjectNya TransitPhoto (2)
http://wonderfl.net/c/p6w0
zonnbe explosion of 溶岩！
http://wonderfl.net/c/pPaT
nitoyon [BetweenAS3] Random Text Tween
http://wonderfl.net/c/pTS6
rsakane forked from: Checkmate Vol.6 Sponser
http://wonderfl.net/c/pUdA
ProjectNya Tatami 畳
http://wonderfl.net/c/pUkB
ProjectNya LightTune + SoundMixer
http://wonderfl.net/c/pZNH
nemu90kWw ダラ外宇宙水槽 for Wonderfl
http://wonderfl.net/c/peA4
okmt_masaaki Bitmap transition
http://wonderfl.net/c/ph57
ProjectNya BurnPict
http://wonderfl.net/c/ppAR
rsakane ウゴツールの劣化版
http://wonderfl.net/c/pswv
nitoyon Perfect Shuffle Visualization
http://wonderfl.net/c/qKxA
o_healer アクトレーザー
http://wonderfl.net/c/qSFM
AtuyL トランプタワー破壊 ボタン - forked from: Button
http://wonderfl.net/c/qVmD
makc3d Another Mandelbrot zoomer
http://wonderfl.net/c/qj1s
clockmaker closure graphics
http://wonderfl.net/c/qlFz
tencho おいでよワンコとかの森
http://wonderfl.net/c/qvoZ
keim_at_Si Bound Ball Synthesizer 2
http://wonderfl.net/c/rTG1
keno42 のんびり眺める用
http://wonderfl.net/c/rXE6
clockmaker Text speech by Google API
http://wonderfl.net/c/rgyc
OKASUKE Thurs grow 3D(伸びてゆく木 PV3D)
http://wonderfl.net/c/rmxt
matsu4512 Colorful Clock Circulation
http://wonderfl.net/c/rqJW
shohei909 うにょうにょ
http://wonderfl.net/c/rrle
sekiryou 燕子花図屏風
http://wonderfl.net/c/rwdU
uwi Phase of Windows
http://wonderfl.net/c/s1j5
ProjectNya チョーク (4)
http://wonderfl.net/c/s21T
ProjectNya SorcerersFingerSound [color] - 魔法使いの指
http://wonderfl.net/c/sGB5
kiyobu lightning
http://wonderfl.net/c/sM3y
nemu90kWw Mosaic Smoke
http://wonderfl.net/c/sSGe
osamX SoundBall
http://wonderfl.net/c/sfdx
Nyarineko TextPlane3DEfect
http://wonderfl.net/c/stRB
ProjectNya Fireworks
http://wonderfl.net/c/sxyt
ABA Voxcape
http://wonderfl.net/c/t0ac
okmt_masaaki drawTrianglesTest2
http://wonderfl.net/c/tBcH
rsakane マインスイーパー
http://wonderfl.net/c/tEp4
usagifrask 賢者の鼓動 -Philosopher's Heart Beat-
http://wonderfl.net/c/tJ4V
umhr Picasa+face.com
http://wonderfl.net/c/tJXN
clockmaker Sakura Particle with Stardust
http://wonderfl.net/c/tLIW
uwi Twitter Common Members Counter
http://wonderfl.net/c/tYnQ
nulldesign NDView3D
http://wonderfl.net/c/tfsU
mousepancyo 光るリボン（Ribbon Light）
http://wonderfl.net/c/thVu
ProjectNya ドット地形
http://wonderfl.net/c/ticj
narutohyper IK Bone Sample
http://wonderfl.net/c/tj5H
uwi Square Game
http://wonderfl.net/c/tlE3
keim_at_Si Puppyish Pentatonicism
http://wonderfl.net/c/toV4
buccchi オッス、おらロク！
http://wonderfl.net/c/tpoY
m0ose flash on 2010-9-15
http://wonderfl.net/c/u9oV
matsu4512 Colorful Physics Balls
http://wonderfl.net/c/uDBd
zonnbe sound galaxy v0.2
http://wonderfl.net/c/uRNO
yooKo PV3DのDO3DでMaskをかけるTest【In sphere mask】
http://wonderfl.net/c/uaKO
alumican_net Fire Slash
http://wonderfl.net/c/ucSe
paq [Stardust] HANABI
http://wonderfl.net/c/ufqm
ProjectNya LightFolium
http://wonderfl.net/c/uiOL
narutohyper turn the pages transition
http://wonderfl.net/c/ujZ5
ProjectNya Flare 燃えろよ♪燃えろよ♪
http://wonderfl.net/c/usCF
motikawa_rgm マリージ
http://wonderfl.net/c/v0HW
ProjectNya TransitBlock
http://wonderfl.net/c/v4T4
kuma360 雑魚ゲー
http://wonderfl.net/c/vAlp
clockmaker drawTriangles for Flash Player 9
http://wonderfl.net/c/vBEV
nitoyon Rainbow Glow Effect
http://wonderfl.net/c/vM5c
knd もっちりボロノイ図
http://wonderfl.net/c/vRZn
makc3d Fast texture extraction
http://wonderfl.net/c/vbla
Saqoosha Mosaic
http://wonderfl.net/c/vhTF
uwi Broken Pieces
http://wonderfl.net/c/w3PE
Murai Milkyway forked from: soundtest6
http://wonderfl.net/c/w4YR
ProjectNya ドットひよこ (ぐるぐる)
http://wonderfl.net/c/wNSx
uwi 天の光はすべて敵
http://wonderfl.net/c/wRyv
tencho Environment Mapping Test
http://wonderfl.net/c/wWCN
narutohyper Alternativa3D Cover Flow
http://wonderfl.net/c/wu6T
osamX ワンダフルクエスト
http://wonderfl.net/c/wu8f
shapevent Connect The Dots
http://wonderfl.net/c/wvdi
ProjectNya ドットにゃんこ
http://wonderfl.net/c/wvru
yooKo 3D text of fire
http://wonderfl.net/c/wzim
enok Noise Instrument
http://wonderfl.net/c/x9a3
Aquioux Voronoi Letter
http://wonderfl.net/c/xKnl
narutohyper Alternativa3Dでルービックキューブ 5x5
http://wonderfl.net/c/xOAv
psyark one more thing
http://wonderfl.net/c/xOVc
nulldesign flash on 2010-4-19
http://wonderfl.net/c/xjdM
shohei909 スイッチーズ - swithches
http://wonderfl.net/c/xlbr
o_healer Lock＆Roll
http://wonderfl.net/c/xq5y
rsakane キャラ / マップチップ表示
http://wonderfl.net/c/y0cw
makc3d Realtime Mandelbrot zoomer
http://wonderfl.net/c/yDrn
Murai TrippyAtractor
http://wonderfl.net/c/yEFY
imajuk Water Color
http://wonderfl.net/c/yYR7
enok Flower
http://wonderfl.net/c/ys87J
ProjectNya LightCircle
http://wonderfl.net/c/yyO7
_wonder フォワードキネマティクス：歩行
http://wonderfl.net/c/z28L
sakef simple 3D 01 (not using PV3D)
http://wonderfl.net/c/z3To
ProjectNya カラー補正
http://wonderfl.net/c/z5Bs
mash Sakura Tree
http://wonderfl.net/c/zIfd
HaraMakoto Light Effect
http://wonderfl.net/c/zUNw
ProjectNya Cube
http://wonderfl.net/c/ze7j
ProjectNya EscapeDot
http://wonderfl.net/c/ztPH
clockmaker [PV3D] Refrection Cube - Gradation Version
http://wonderfl.net/c/zvod
ikke SoundVisualizerTest
http://wonderfl.net/c/zvqy
matsu4512 星屑ブロック崩し
http://wonderfl.net/c/zxTj
narutohyper IKBone & imageMesh つまりはイルカを動かしてみたかった
http://wonderfl.net/c/10eI
zendenmushi soundSpectrum with Dropwater
http://wonderfl.net/c/13um
narutohyper Heart Beat Clock
http://wonderfl.net/c/1QMC
Nicolas [Stardust] RendererにcopyPixelsを使う（向きのあるパーティクル版）
http://wonderfl.net/c/1VnB
zendenmushi beedama-korokoro
http://wonderfl.net/c/1qWQ
zendenmushi MetaBowl 2.5D
http://wonderfl.net/c/2042
bkzen Number touch
http://wonderfl.net/c/2A9V
tencho PythagoraSwitch
http://wonderfl.net/c/2F0r
178ep3 17Poker
http://wonderfl.net/c/2X31
okoi 描いたラインが芋虫のように追いかけてきます
http://wonderfl.net/c/2v5b
ProjectNya Calendar (祝日あり)
http://wonderfl.net/c/3Roc
coppieee 重力マウス（さらに軽量化してみた）
http://wonderfl.net/c/436W
nbhd BoonDockRadioBackGround
http://wonderfl.net/c/4vnu
ProjectNya MP3Player (1)
http://wonderfl.net/c/5Kfb
o_healer シロクロ×ダイバー：「市松」ステージ
http://wonderfl.net/c/5QKQ
narutohyper IKBone & imageMesh でも本当の目的はこっちだったりして。
http://wonderfl.net/c/5kax
narutohyper Text Transformer
http://wonderfl.net/c/5qU8
k3lab Amphisbaena
http://wonderfl.net/c/691A
paq [Stardust] KiraKira Waypoints
http://wonderfl.net/c/6Z8A
zendenmushi Play with Waterdrop (激重 注意！)
http://wonderfl.net/c/6ytk
jmp909 forked from: Icosahedron
http://wonderfl.net/c/7B9Y
nanlow DrawTriangles Book
http://wonderfl.net/c/7NRD
okoi ElectricEffect
http://wonderfl.net/c/7prR
rect Metatunnel
http://wonderfl.net/c/84iA
paq [Stardust] Rainbow Pixels
http://wonderfl.net/c/8t8M
nabe 屈折ドーナツ
http://wonderfl.net/c/9eE0
paq [Stardust][PV3D] Depth of field
http://wonderfl.net/c/AgcS
kkeisuke Particle Test
http://wonderfl.net/c/H33c
yuuganisakase [Box2D]Pendulum Clock （振り子時計のような何か）
http://wonderfl.net/c/a047
mex_ny forked from: 【AS100本ノック】10回目：爆破
http://wonderfl.net/c/aGoH
nemu90kWw 極悪マップ作ってみた forked from: Wall×Walk
http://wonderfl.net/c/aItp
nackpan IsometricProjectionText 等角投影立体文字
http://wonderfl.net/c/aXfA
sakusan393 Twittenorion
http://wonderfl.net/c/ahtc
paq [Stardust][PV3D] TwitterBird
http://wonderfl.net/c/b7zr
tatsuya [Box2d] Mechanical Clock （機械式時計）
http://wonderfl.net/c/b9Ls
paq QuickBox2D練習
http://wonderfl.net/c/biJX
sakusan393 定幅図形（ルーローの三角形）
http://wonderfl.net/c/cE5u
paq [Stardust] RendererにcopyPixelsを使う
http://wonderfl.net/c/cZHu
zendenmushi JapaneseFirefly
http://wonderfl.net/c/cegt
keno42 SiON TETRISizer Online
http://wonderfl.net/c/cifX
soundkitchen ストロボ投影的ななにか
http://wonderfl.net/c/dFCR
o8que Flamethrower ～ハート様に火をつけて～
http://wonderfl.net/c/dUXf
o_healer シロクロ×ダイバー
http://wonderfl.net/c/e5y9
paq [QuickBox2D] Doll
http://wonderfl.net/c/eRwr
nackpan 3D Balls
http://wonderfl.net/c/eoZQ
aomoriringo 2001年宇宙の旅的な
http://wonderfl.net/c/esp4
zonnbe loco roco v0.2 (改造PuyoDot)
http://wonderfl.net/c/ev9L
bkzen [QuickBox2D]スライム
http://wonderfl.net/c/f3uO
keim_at_Si SiON TETRISizer
http://wonderfl.net/c/f5eX
paq [QuickBox2D] Doll in space
http://wonderfl.net/c/gDHS
okoi ラインを沢山引きます
http://wonderfl.net/c/gFv0
abakane PieLoading パイ型ローディング
http://wonderfl.net/c/gqjs
tencho Sea of Clouds
http://wonderfl.net/c/h9dR
tencho File Tree Test
http://wonderfl.net/c/hC7D
bkzen Safecracking Game
http://wonderfl.net/c/hFfA
paq [Stardust] BitmapBurster
http://wonderfl.net/c/hZGr
keim_at_Si Real Time Ray Tracing
http://wonderfl.net/c/horg
tencho レンズフレア
http://wonderfl.net/c/i0dL
alumican_net Sketch of Voronoi
http://wonderfl.net/c/iNy0
tail_y TearPaperEffect
http://wonderfl.net/c/isiH
k3lab Icosahedron
http://wonderfl.net/c/ivlx
ProjectNya MenuDock
http://wonderfl.net/c/j3FU
paq [QuickBox2D] Soft body
http://wonderfl.net/c/jCI0
Murai FluidMusicLamp forked from: SwingingLight
http://wonderfl.net/c/jeXJ
bkzen What the hex
http://wonderfl.net/c/kYyY
sakusan393 RealCircle -速く、大きく、正確に正円を書く-
http://wonderfl.net/c/kagi
okoi EmissionCreature
http://wonderfl.net/c/kpEf
tencho Waterfall
http://wonderfl.net/c/kvkU
romatica What's This Bit ? (2進数を当てるゲーム)
http://wonderfl.net/c/lZNa
9re Buddhabrot
http://wonderfl.net/c/mAan
sekiryou 灯籠流し
http://wonderfl.net/c/mCZB
keim_at_Si Click me, if you can
http://wonderfl.net/c/n4Ku
zendenmushi 偽屈折つきスライム (forked from: [QuickBox2D]スライム)
http://wonderfl.net/c/nNPo
Test_Dept Gear
http://wonderfl.net/c/nNqE
undo 高速化　forked from: 止まったらハジケる玉
http://wonderfl.net/c/ntcH
ProjectNya ひよこちゃん簡易チャット
http://wonderfl.net/c/o1Wq
o_healer Wall×Walk
http://wonderfl.net/c/oIST
paq VoiceChat
http://wonderfl.net/c/p2KD
makc3d GeoDarts
http://wonderfl.net/c/pPk3
bkzen AS3クラスったー
http://wonderfl.net/c/qSL0
paq [Stardust] Pixel3D with a brilliant radiance
http://wonderfl.net/c/qTwn
dubfrog 音 MathGraphics SoundVisualizer
http://wonderfl.net/c/qwBh
zendenmushi バーチャル鷹匠(VirtualHawk)
http://wonderfl.net/c/r9gL
bkzen SWF Header Reader
http://wonderfl.net/c/r9iI
Aquioux [WebCam] Manic Monday
http://wonderfl.net/c/rKiz
zonnbe there is no spoon
http://wonderfl.net/c/rjp7
lagash 手描きアニメ風？線文字 Ver.1
http://wonderfl.net/c/rqq8
HaraMakoto SwingingLight forked from: Fluid on the Video
http://wonderfl.net/c/sFXf
ProjectNya FlickrMultiLoader
http://wonderfl.net/c/sI8g
fumix Voronoi Face
http://wonderfl.net/c/sb5Q
narutohyper IKBone Ver2 (角度制限付き)
http://wonderfl.net/c/scrW
tencho MediaRSS City
http://wonderfl.net/c/suNP2
paq [Stardust] COLORFUL
http://wonderfl.net/c/ug7d
demouth Liquid metal
http://wonderfl.net/c/ujmT
narutohyper Dolphin Play [Alternativa3D7.5 Sample]
http://wonderfl.net/c/v8dh
ProjectNya Reversi
http://wonderfl.net/c/vDfO
ProjectNya TrackLight (1)
http://wonderfl.net/c/vMFv
zendenmushi ミツバチを歩かせたくなった
http://wonderfl.net/c/vlgZ
narutohyper Image Mesh Generator
http://wonderfl.net/c/voB0
paq [QuickBox2D] addPolyを使って自由な形の物体を作る
http://wonderfl.net/c/vv9m
dubfrog MediaRSS - DotFlower's EffectViewer
http://wonderfl.net/c/wAUm
ABA DANCE ON RADAR
http://wonderfl.net/c/wi2E
zendenmushi fussa-fussa
http://wonderfl.net/c/xEwN
Nicolas Electric potential
http://wonderfl.net/c/xFWj
fernet ToyCamera トイカメラ風エフェクト
http://wonderfl.net/c/xaas
paq [Stardust] Rain
http://wonderfl.net/c/yTGI
paq [Stardust] + [Box2D]
http://wonderfl.net/c/yYmV
bkzen Movie 15 Puzzle
http://wonderfl.net/c/yb0z
paq [QuickBox2D] + [Stardust]
http://wonderfl.net/c/yksh
clockmaker Version Check for Flash Player 10.1
http://wonderfl.net/c/dcd8
*/