/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uPiz
 */

package  
{
	import caurina.transitions.Tweener;
	import caurina.transitions.Equations;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.system.Security;
	import mx.effects.easing.Quadratic;
	
	import net.wonderfl.utils.SequentialLoader;
	/**
	 * @author 9re
	 */
	public class FP10_3D_Turorial extends Sprite
	{
		private const MY_ICON:String = "http://assets.wonderfl.net/images/related_images/1/1c/1c3b/1c3b8d9bfc26fcab4bded661f003ba8621cfd4c6m";
		private var _imageArray:Array = [];
		private var _images:Vector.<Sprite>;
		private var _i:int;
		private var _timer:int;
		private var _mode:int;
		private var _moving:Boolean = false;
		private var _duration:Number = 1;
		
		public function FP10_3D_Turorial() 
		{
			SequentialLoader.loadImages([MY_ICON], _imageArray, onImageLoaded);
			
			transform.perspectiveProjection.projectionCenter = new Point(232, 232);
		}
		
		private function onImageLoaded():void
		{
			var ldr:Loader = _imageArray.pop();
			
			_images = Vector.<Sprite>((new Array(9)).map(function(item:*, i:int, a:Array):Sprite {
				var bd:BitmapData = new BitmapData(ldr.width, ldr.height);
				bd.draw(ldr);
				var sp:Sprite = new Sprite;
				var bm:Bitmap = new Bitmap(bd);
				bm.y = -bm.height / 2;
				bm.x = -bm.width / 2;
				
				sp.y = 232;
				if (i < 4) {
					sp.rotationY = -80;
					sp.x = i * 20 - 20;
				} else if (i > 4) {
					sp.rotationY = 80;
					sp.x = 305 + i * 20
				} else {
					sp.rotationY = 0;
					sp.x = 232;
				}
					
				
				
				// flash player 10の機能
				sp.z = 100;
				sp.addChild(bm);
				addChild(sp);
				
				return sp;
			}));
			setDepth();
			
			addEventListener(Event.ENTER_FRAME, checkMaouse);
		}
		
		private function checkMaouse(e:Event):void 
		{
			_duration = Math.min(mouseX, Math.abs(465 - mouseX));
			_duration /= 232;
			_duration = Math.abs(_duration);
			_duration += 0.4;
			_duration = Math.max(0.1, _duration * _duration);
			
			if (mouseX < 200 && _mode != -1 && !_moving) {
				_mode = -1;
				left();
			} else if (mouseX > 262 && _mode != 1 && !_moving) {
				_mode = 1;
				right();
			} else {
				_mode = 0;
			}
		}
		

		private function left():void {
			_images.push(_images.shift());
			move();
		}
		
		private function right():void
		{
			_images.unshift(_images.pop());
			move();
		}
		
		private function move():void {
			_moving = true;
			_images.forEach(function(b:Sprite, i:int, v:Vector.<Sprite>):void {
				var sp:Object = { };
				if (i < 4) {
					sp.rotationY = -80;
					sp.x = i * 20 - 20;
				} else if (i > 4) {
					sp.rotationY = 80;
					sp.x = 305 + i * 20
				} else {
					sp.rotationY = 0;
					sp.x = 232;
				}
				
                if (i == _images.length - 1 || i == 0)
				    b.visible = false;
				 else 
				    b.visible = true;
				
				Tweener.addTween(b, {
					x: sp.x,
					rotationY: sp.rotationY,
					transition: Equations.easeOutQuad,
					time:_duration,
					onComplete:setFlag
				});
			});
			setDepth();
		}
		
		private function setFlag():void
		{
			_moving = false;
		}
		
		private function setDepth():void {
		    for (i = 0; i < 4; ++i) {
		        addChild(_images[i]);
		    }
		    
		    for (var i:int = _images.length - 2; i > 4; --i) {
		        addChild(_images[i]);
		    }
		    
		    addChild(_images[4]);
		}
		
	}

}