/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uPgf
 */

// [実験] BitmapDataのチャネルを入れ替えるのはどうやれば高速か？
// 修正：ColorMatrixFilter一回に対してcopyChannel三回は
//     かわいそうなので一対一にした（それでも遅いけど）。
package {

import flash.display.*;
import flash.filters.*;
import flash.geom.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    private var _src:BitmapData;
    private var _dst:BitmapData;
    private var _rect:Rectangle;
    private var _zero:Point;
    
    //ColorMatrixFilterで入れ替える用
    private var _cmf:ColorMatrixFilter;
    
    public function Main():void
    {
        _src = new BitmapData(500, 500, false, 0x0);
        _src.noise(1);
        _dst = new BitmapData(500, 500, false, 0x0);
        _rect = new Rectangle(0, 0, 500, 500);
        _zero = new Point(0, 0);
        
        /*
        //R->G, G->B, B->R
        _cmf = new ColorMatrixFilter([
            0, 0, 1, 0, 0,
            1, 0, 0, 0, 0,
            0, 1, 0, 0, 0,
            0, 0, 0, 1, 0
        ]);
        */
        
        //R->G
        _cmf = new ColorMatrixFilter([
            1, 0, 0, 0, 0,
            1, 0, 0, 0, 0,
            0, 0, 1, 0, 0,
            0, 0, 0, 1, 0
        ]);
        
        _setup();
        
        _measure("BitmapData.copyChannelでチャネルを入れ替える", function ():void
        {
            _dst.copyChannel(_src, _rect, _zero, BitmapDataChannel.RED  , BitmapDataChannel.GREEN);
            //_dst.copyChannel(_src, _rect, _zero, BitmapDataChannel.GREEN, BitmapDataChannel.BLUE );
            //_dst.copyChannel(_src, _rect, _zero, BitmapDataChannel.BLUE , BitmapDataChannel.RED  );
            
        }, 100);
        
        _measure("ColorMatrixFilterでチャネルを入れ替える", function ():void
        {
            _dst.applyFilter(_src, _rect, _zero, _cmf);
            
        }, 100);
    }
    
    private function _measure(
        title:String, func:Function, numTimes:uint, ...params):void
    {
        _time = getTimer();
        
        for (var i:int = 0; i < numTimes; i++) {
            func.apply(null, params);
        }
        
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth;
        _field.height = stage.stageHeight;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
    }
}

}