/**
 * Copyright amashio ( http://wonderfl.net/user/amashio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uOD7
 */

package{
    
    import flash.display.Sprite;
    import flash.display.*;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.ui.Keyboard;
    
    public class Main extends Sprite{
        
        private static const INIT_THICKNESS:uint = 5;
        private static const MAX_THICKNESS:uint = 50;
        private static const MIN_THICKNESS:uint = 1;
        
        private var _thickness:uint;
        private var _drawing:Boolean;
        private var _commands:Vector.<IGraphicsData>;
        private var _lineStyle:GraphicsStroke;
        private var _currentPath:GraphicsPath;
        
        public function Main(){
            init();
        }
        
        public function init():void{
            var color:uint = Math.random()*0xFFFFFF;
            _thickness = INIT_THICKNESS;
            graphics.lineStyle(_thickness, color);
            _lineStyle = new GraphicsStroke(_thickness);
            _lineStyle.fill = new GraphicsSolidFill(color);
            _commands = new Vector.<IGraphicsData>();
            _commands.push(_lineStyle);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onStageKeyDown);
        }
        
        private function redrawPath():void{
            graphics.clear();
            graphics.drawGraphicsData(_commands);
        }
        
        private function onStageKeyDown(event:KeyboardEvent):void{
            if(!_drawing){
                switch(event.keyCode){
                    case Keyboard.UP:
                        if(_thickness < MAX_THICKNESS){
                            _lineStyle.thickness = ++_thickness;
                            redrawPath();
                        }
                        break;
                        
                    case Keyboard.DOWN:
                        if(_thickness > MIN_THICKNESS){
                            _lineStyle.thickness = --_thickness;
                            redrawPath();
                        }
                        break;
                    case Keyboard.SPACE:
                        _lineStyle.fill = new GraphicsSolidFill(Math.random()*0xFFFFFF);
                        redrawPath();
                        break;
                }
            }
        }
        
        private function onStageMouseDown(event:MouseEvent):void{
            _drawing = true;
            var x:Number = stage.mouseX;
            var y:Number = stage.mouseY;
            _currentPath = new GraphicsPath();
            _currentPath.moveTo(x, y);
            _commands.push(_currentPath);
            graphics.moveTo(x, y);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
        }
        
        private function onStageMouseMove(event:MouseEvent):void{
            var x:Number = stage.mouseX;
            var y:Number = stage.mouseY;
            _currentPath.lineTo(x, y);
            graphics.lineTo(x, y);
            event.updateAfterEvent();
        }
        
        private function onStageMouseUp(event:MouseEvent):void{
            _drawing = false;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
        }
    }
}