/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uMzS
 */

// forked from ProjectNya's SorcerersFingerSound [color] - 魔法使いの指
// forked from gaina's soundtest7 - E.R.O
// forked from cpu_t's SorcerersFinger - 魔法使いの指
////////////////////////////////////////////////////////////////////////////////
// SorcerersFingerSound [color] - 魔法使いの指
// 
// gaina's soundtest7 - E.R.O [http://wonderfl.net/c/2VSs]
// cpu_t's SorcerersFinger - 魔法使いの指 [http://wonderfl.net/c/646E]
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var head:FireNode;
        private var tail:FireNode;
        private var fingerPos:Object;
        private var power:Number;
        private var mousePos:Array = [232, 232];
        private var sound:Sound;
        private const loopNum:int = 3;
        private static var soundPath:String = "http://www.takasumi-nagai.com/soundfiles/sound001.mp3";

        public function Main() {
            Wonderfl.capture_delay(11);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var rect:Rectangle = new Rectangle(30, 30, 405, 405);
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        }
        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            start();
        }
        private function start():void {
            fingerPos = {x: 232, y: 232, vx: 0, vy: 0};
            power = 0;
            var channel:SoundChannel = sound.play(0, 5);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 1);
            for (var n:uint = 0; n < 2; n++) {
                for (var t:uint = 0; t < 256; t++) {
                    var rf:Number = bytes.readFloat();
                    if (Math.random() < 0.5) {
                        mousePos[n] = 232 + rf*232;
                    } else {
                        mousePos[n] = 232 - rf*232;
                    }
                }
            }
            var fnode:FireNode;
            for(var i:uint = 0; i < loopNum; i++) {
                fingerPos.vx *= 0.75;
                fingerPos.vy *= 0.75;
                fingerPos.vx += (mousePos[0] - fingerPos.x)*0.2*(i+1)/loopNum;
                fingerPos.vy += (mousePos[1] - fingerPos.y)*0.2*(i+1)/loopNum;
                fingerPos.x += fingerPos.vx;
                fingerPos.y += fingerPos.vy;
                power += Math.sqrt(fingerPos.vx*fingerPos.vx + fingerPos.vy*fingerPos.vy)*1.6*i/loopNum;
                power *= 0.85;
                if(power > 100) power = 100;
                fnode = new FireNode(power);
                addChild(fnode);
                fnode.x = fingerPos.x - fingerPos.vx*i/loopNum + (Math.random()-0.5)*30;
                fnode.y = fingerPos.y - fingerPos.vy*i/loopNum + (Math.random()-0.5)*30;
                fnode.vx = fingerPos.vx*0.3;
                fnode.vy = fingerPos.vy*0.3;
                if (head==null) {
                    head=tail=fnode;
                } else {
                    fnode.prev = tail;
                    tail = tail.next=fnode;
                }
            }
            fnode=head;
            while (fnode!=null) {
                fnode.update();
                if (fnode.isDead) {
                    removeChild(fnode);
                    if (fnode.prev == null) {
                        head = fnode.next;
                    } else {
                        fnode.prev.next = fnode.next;
                    }
                    if (fnode.next == null) {
                        tail = fnode.prev;
                    } else{
                        fnode.next.prev = fnode.prev;
                    }
                }
                fnode = fnode.next;
            }
        }

    }

}


import flash.display.BlendMode;
import flash.display.Sprite;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class FireNode extends Sprite {
    public var next:FireNode;
    public var prev:FireNode;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var isDead:Boolean = false;
    private static var filetr:BlurFilter=new BlurFilter(16,16);

    public function FireNode(size:Number = 30) {
        var color:ColorHSV = new ColorHSV(Math.random()*360, Math.random()*0.4 + 0.6);
        graphics.beginFill(color.value);
        graphics.drawCircle(0, 0, size);
        blendMode = BlendMode.ADD;
        filters=[filetr];
    }
    
    
    public function update():void {
        if (width < 10) {
            isDead = true;
            return;
        }
        scaleX = scaleY *= 0.95;
        vx *= 0.95;
        vy *= 0.95;
        x += vx;
        y += vy;
    }
}
