/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uMj5
 */

package {
	import com.bit101.components.PushButton;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.net.FileFilter;
	import flash.net.FileReference;

	/**
	 * One possible way to fix the code;
	 * I am still open for other options.
	 */
	public class MarchingSquares extends Sprite {
		public var file:FileReference, loader:Loader;
		public var image:BitmapData, image2:BitmapData;
		public function MarchingSquares () {
			file = new FileReference;
			file.addEventListener (Event.SELECT, onFileSelected);
			file.addEventListener (Event.COMPLETE, onFileLoaded);
			new PushButton (this, 0, 0, "LOAD IMAGE", onButtonClicked);
		}
        public function onButtonClicked (e:Event):void {
			file.browse ([new FileFilter ("Black'n'white image, please", "*.gif;*.png")]);
		}
        public function onFileSelected (e:Event):void { file.load (); }
        public function onFileLoaded (e:Event):void {
			loader = new Loader;
			loader.contentLoaderInfo.addEventListener (Event.COMPLETE, onImageReady);
			loader.loadBytes (file.data);
		}
		public function onImageReady(e:Event):void {
			if (loader.content) {
				loader.contentLoaderInfo.removeEventListener (Event.COMPLETE, onImageReady);

				image = loader.content ["bitmapData"];
				removeChildAt (0); addChild (new Bitmap (image));

				// threshold it just in case
				image.threshold (image, image.rect, image.rect.topLeft, ">=", 127, 0xFFFFFFFF, 0xFF);
				image.threshold (image, image.rect, image.rect.topLeft, "<",  127, 0xFF000000, 0xFF);

				image2 = new BitmapData (image.width, image.height, true, 0);
				addChild (new Bitmap (image2));

				w = image.width;
				at = new Point (0, image.height >> 1);
				imageData = image.getVector (image.rect);
				addEventListener (Event.ENTER_FRAME, marchingSquares);
			}
		}
		public var d:uint = 3; // 0 up 1 left 2 down 3 right
		public var at:Point, w:int, imageData:Vector.<uint>;
		public function marchingSquares (e:Event):void {
			var nw:uint = imageData [w * at.y + at.x] & 1;
			var ne:uint = imageData [w * at.y + at.x + 1] & 1;
			var sw:uint;
			var se:uint;
			if ((ne == 1) && (nw == 0)) {
				if (d == 3) {
					// we go up
					at.y--; d = 0;
				} else {
					sw = imageData [w * (at.y + 1) + at.x] & 1;
					se = imageData [w * (at.y + 1) + at.x + 1] & 1;
					if ((sw == 1) && (se == 0)) {
						// we go down
						at.y++; d = 2;
					} else {
						// we still go up
						at.y--; d = 0;
					}
				}
			} else {
				sw = imageData [w * (at.y + 1) + at.x] & 1;
				if ((nw == 1) && (sw == 0)) {
					if (d == 0) {
						// we go left
						at.x--; d = 1;
					} else {
						se = imageData [w * (at.y + 1) + at.x + 1] & 1;
						if (se == 1) {
							// we go right
							at.x++; d = 3;
						} else {
							// we still go left
							at.x--; d = 1;
						}
					}
				} else {
					se = imageData [w * (at.y + 1) + at.x + 1] & 1;
					if ((sw == 1) && (se == 0)) {
						// we go down
						at.y++; d = 2;
					} else {
						// we go right
						at.x++; d = 3;
					}
				}
			}
			image2.setPixel32 (at.x, at.y, 0xFFFF0000);
		}
	}
}