/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uLty
 */

// フーリエ変換
// http://d.hatena.ne.jp/piraki/20090423/1240462020
// 
package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
    public class FlashTest extends Sprite
	{
		private var g:Graphics;
		private var dataview:Sprite;
		private var data:Vector.<Number>;
        public function FlashTest()
		{
			data = new Vector.<Number>();
			for (var i:int = 0; i < 256; i++)
			{
				data[i] = Math.sin(i / 256 * Math.PI * 2 * 2)*.8;
				data[i] += Math.sin(i / 256 * Math.PI * 2 * 100)*.2;
			}
			
			var sp:Sprite = new Sprite();
			sp.addChild(dataview = new Sprite());
			addChild(sp);
			
			g = sp.graphics;
			g.beginFill(0xE0E0E0);
			g.drawRect(0, 0, 256, 200);
			g.endFill();
			g.lineStyle(1, 0xFF0000);
			g.moveTo(0, 100); g.lineTo(256, 100);
			g.endFill();
            
			g.lineStyle(1, 0xFF0000);
			g.moveTo(0, 300); g.lineTo(256, 300);
			g.endFill();
			
			reset();
			
			// data input
			var isMouseDown:Boolean = false;
			var lastMousePos:Point = new Point();
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void
			{
				isMouseDown = true;
			});
			stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void
			{
				isMouseDown = false;
				reset();
			});
			stage.addEventListener(Event.ENTER_FRAME, function(e:Event):void
			{
				if (isMouseDown && mouseY >= 0 && mouseY <= 200)
				{
					var x:int = mouseX;
					if (lastMousePos.x < x)
					{
						x = lastMousePos.x;
						lastMousePos.x = mouseX;
					}
					if (x < 0) x = 0;
					if (lastMousePos.x > 256) lastMousePos.x = 256;
					while (x < lastMousePos.x)
					{
						data[x] = (100 - mouseY) / 100;
						x++;
					}
					reset();
				}
				lastMousePos.x = mouseX;
				lastMousePos.y = mouseY;
			});
        }
		
		private function reset():void
		{
			g = dataview.graphics;
			g.clear();
			g.lineStyle(1, 0);
			g.moveTo(0, data[0]);
			for (var i:int = 0; i < data.length; i++)
			{
				g.lineTo(i, 100 -data[i] * 100);
			}
			g.endFill();
			
			var out:Vector.<Number> = f(data);
			
			g.lineStyle(1, 0);
			g.moveTo(0, 300);
			for (i = 0; i < out.length; i++)
			{
				g.lineTo(i, 300 - out[i] * 100);
			}
			g.endFill();
		}
		
		private function f(data:Vector.<Number>):Vector.<Number>
		{
			var out:Vector.<Number> = new Vector.<Number>();
			var re:Vector.<Number> = new Vector.<Number>();
			var im:Vector.<Number> = new Vector.<Number>();
			var n:int = data.length;
			for (var i:int = 0; i < n; i++)
			{
				re[i] = im[i] = 0;
				for (var j:int = 0; j < n; j++)
				{
					re[i] += data[j] * Math.cos(2 * Math.PI * i * j / n);
					im[i] -= data[j] * Math.sin(2 * Math.PI * i * j / n);
				}
				out[i] = Math.sqrt(re[i] * re[i] + im[i] * im[i]) / n;
				
			}
			return out;
		}
    }
}