/**
 * Copyright tonpoo ( http://wonderfl.net/user/tonpoo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uLpQ
 */

// forked from tonpoo's 100個のボタンに異なる値を割り振り
package {
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.utils.Dictionary;
	public class FlashTest extends Sprite {
		public function FlashTest() {
			/*
			 * ステージ上にボタンを配置することができないので、
			 * とりあえずbtn0～btn2までを動的に生成・配置
			 * */
			//btn0～btn2までを生成＆ランダムに配置
			btn0 = new Btn();
			btn1 = new Btn();
			btn2 = new Btn();
			this.addChild(btn0);
			this.addChild(btn1);
			this.addChild(btn2);
			btn0.x = Math.floor(Math.random() * this.stage.stageWidth);
			btn0.y = Math.floor(Math.random() * this.stage.stageHeight);
			btn1.x = Math.floor(Math.random() * this.stage.stageWidth);
			btn1.y = Math.floor(Math.random() * this.stage.stageHeight);
			btn2.x = Math.floor(Math.random() * this.stage.stageWidth);
			btn2.y = Math.floor(Math.random() * this.stage.stageHeight);
			
			/*
			 * 以下はステージ上にbtn0～btn2があるという想定で。
			 * */
			 //Dictionaryインスタンスに、各ボタンインスタンスへの参照をキーとして出力内容を記録
			msgs = new Dictionary();
			msgs[btn0] = "ひ";
			msgs[btn1] = "よ";
			msgs[btn2] = "こ";
			
			//イベントリスナーの登録
			btn0.buttonMode = true;
			btn0.addEventListener(MouseEvent.CLICK, onBtnClick, false, 0, true);
			btn1.buttonMode = true;
			btn1.addEventListener(MouseEvent.CLICK, onBtnClick, false, 0, true);
			btn2.buttonMode = true;
			btn2.addEventListener(MouseEvent.CLICK, onBtnClick, false, 0, true);
			 
			//出力表示用TextFieldの生成
			traceField = new TextField();
			this.addChild(traceField);
			traceField.width = this.stage.stageWidth;
			traceField.height = 20;
			traceField.border = true;
			traceField.background = true;
		}

		private var traceField:TextField;
		private var btn:Btn;
		private var msgs:Dictionary;
		
		private var btn0:Sprite;
		private var btn1:Sprite;
		private var btn2:Sprite;

		private function onBtnClick(e:MouseEvent):void {
			//自分自身への参照をキーとしてmsgsから対応する文字列を取得して出力
			btn = e.target as Btn;
			traceField.text = msgs[btn];
		}
	}
}

/*
 * Spriteクラスを拡張したボタン用クラス。
 * */
class Btn extends Sprite {
	public function Btn() {
		//赤丸の描画
		this.graphics.beginFill(0xFF0000);
		this.graphics.drawCircle(0, 0, 6);
		this.graphics.endFill();
	}
}