/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uLOp
 */

package
{
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Instance extends Sprite
    {
        public function Instance()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.9);
            graphics.drawRect  (0, 0, (stage.stageWidth - 1), (stage.stageHeight - 1));
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            _init();
            
            addChild(new Dialog_Access);
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Dialog_Access extends Sprite
{
    protected var _x :Number;
    protected var _y :Number;
    
    private const WIDTH :Number = 164;
    private const HEIGHT :Number = 80;
    
    public function Dialog_Access()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function _init() :void
    {
        graphics.clear     ();
        graphics.lineStyle (1, 0, 0.9);

        //header
        graphics.beginFill (0, 0.4);
        graphics.drawRect  (x, (y - 20), WIDTH, 20);
        graphics.endFill   ();
        
        //body
        graphics.beginFill (0, 0.25);
        graphics.drawRect  (x, y, WIDTH, HEIGHT);
        graphics.endFill   ();

    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = ((stage.stageWidth / 2) - (WIDTH / 2));
        _y = ((stage.stageHeight / 2) - (HEIGHT / 2));
        
        _init();
             
        addChild(new Text_Output("Dialog_Access", (x + 2), (y - 20)));
        addChild(new Text_Input("Username", (x + 8), (y + 16), 92, 20));
        addChild(new Text_Input("Password", (x + 8), (y + 44), 92, 20));
        addChild(new Button((x + (WIDTH - 57)), (y + 17), 48, 48));
    }
    
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    
    public override function set x($:Number) :void
    { _x = $; _init(); }
    public override function set y($:Number) :void
    { _y = $; _init(); }
}

class Button extends Sprite
{
    protected var _x :Number;
    protected var _y :Number;
    protected var _width :Number;
    protected var _height :Number;
    protected var _alpha :Number;
    
    public function Button($x:Number, $y:Number, $width:Number, $height:Number, $alpha:Number = 0.5)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _width = $width;
        _height = $height;
        _alpha = $alpha;
    }
    
    public function _init() :void
    {
        graphics.clear     ();
        graphics.lineStyle (1, 0, 0.9);
        
        graphics.beginFill (0, _alpha);
        graphics.drawRect  (_x, _y, _width, _height);
        graphics.endFill   ();
        
        graphics.beginFill (0x00FF00, (_alpha - 0.17));
        graphics.moveTo    (_x, _y);
        graphics.lineTo    ((_x + (_width * 0.66)), (_y + (_height / 2)));
        graphics.lineTo    (_x, (_y + _height));
        graphics.lineTo    ((_x + (_width * 0.33)), (_y + _height));
        graphics.lineTo    ((_x + _width), (_y + (_height / 2)));
        graphics.lineTo    ((_x + (_width * 0.33)), (_y));
        graphics.endFill   ();
    }

    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();    
        
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    public function onMouseOver($e:MouseEvent) :void
    {
        alpha = 0.4;   
        
        addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
    }
    
    public function onMouseOut($e:MouseEvent) :void
    {
        removeEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
    
        alpha = 0.5;
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        alpha = 0.3;
        
        addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    
        alpha = 0.5;
    }
    
    public override function get alpha() :Number
    {return _alpha}
    
    public override function set alpha($:Number) :void
    {_alpha = $; _init();}
}

class Text_Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    
    public function Text_Output($content:String, $x:Number, $y:Number, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _content = $content;
        _x = $x;
        _y = $y;
        _font = $font;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        text = _content;
        x = _x;
        y = _y;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    
    public function set font($:String) :void
    { _font = $; _init(); }
}

class Text_Input extends TextField
{
    private var textFormat :TextFormat;
    private var bgSprite :Sprite;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _width :Number;
    protected var _height :Number;
    protected var _font :String;
    
    private var defaultContent :String;
    
    public function Text_Input($content:String, $x:Number, $y:Number, $width:Number, $height:Number, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    
        _content = defaultContent = $content;
        _x = $x;
        _y = $y;
        _width = $width;
        _height = $height;
        _font = $font;
        
        bgSprite = new Sprite;
        border = true;
        multiline = false;
        selectable = mouseEnabled = true;
        type = TextFieldType.INPUT;
        antiAliasType = AntiAliasType.ADVANCED;
        defaultTextFormat = textFormat = new TextFormat(_font); 
        setTextFormat(textFormat);
    }
    
    public function _init() :void
    {
        bgSprite.graphics.clear     ();
        bgSprite.graphics.beginFill (0xFFFFFF, 0.5);
        bgSprite.graphics.drawRect  ((_x + 2), (_y + 1), (_width - 2), _height);
        bgSprite.graphics.endFill   ();
        
        text = _content;
        x = _x;
        y = _y;
        width = _width;
        height = _height;
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        parent.addChildAt(bgSprite, parent.getChildIndex(this));
        
        _init();
        
        addEventListener(FocusEvent.FOCUS_IN, onFocusIn);
        addEventListener(FocusEvent.FOCUS_OUT, onFocusOut);
    }   
    
    public function onFocusIn($e:FocusEvent) :void
    {content = ""}
    public function onFocusOut($e:FocusEvent) :void
    {content = (text == "") ? defaultContent : text}
    
    public function get font() :String
    { return _font }
    
    public function set content($:String) :void
    { _content = $; _init(); }
}
