/**
 * Copyright rison ( http://wonderfl.net/user/rison )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uKyd
 */

package 
{
    /**
     * @author max
     */
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import com.actionsnippet.qbox.*;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width=465, height=465, frameRate=60)]
    public class Main extends MovieClip 
    {
        private var sim:QuickBox2D;
        private var center:QuickObject;
         
        public function Main():void 
        {
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(0x111111);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bg.graphics.endFill();
            addChild(bg);
            
            var top:MovieClip = new MovieClip();
            addChild(top);
            sim = new QuickBox2D(top, { gravityY:0 } );
            sim.createStageWalls({lineColor:0x111111,fillColor:0x111111} );
            sim.start();

            addEventListener(Event.ENTER_FRAME, __onEnterFrame);
            var type:String = QuickBox2D.DISTANCE;
    
            var points:Array = [];
            var num : uint = 50;
            for (var i:uint = 0,angle:Number = 0,radius:uint = 150,step:Number = Math.PI*2 / num; i < num; i++)
            {
                var cX:Number = stage.stageWidth / 2 + radius * Math.cos(angle);
                var cY:Number = stage.stageHeight / 2 + radius * Math.sin(angle);
                //box2d circle and joint
                points.push(sim.addCircle( {lineThickness:2,lineAlpha:0, fillAlpha:0,x:cX / 30, y:cY / 30, density:1,radius:0.2} ));
                i > 0?sim.addJoint( {lineThickness:2,lineColor:0xFFFFFF,type:type, a:points[i - 1].body, b:points[i].body } ):0;
                i == num - 1?sim.addJoint( {lineThickness:2,lineColor:0xFFFFFF,type:type, a:points[0].body, b:points[i].body } ):0;
                angle += step;
            }
            
            center = sim.addCircle( {lineThickness:2,lineColor:0xFFFFFF,radius:2.4,fillAlpha:0, x:stage.stageWidth / 2 / 30, y:stage.stageHeight / 2 / 30 - 2.5, density:1 } );
            sim.addCircle( {lineThickness:2,lineColor:0xFFFFFF,radius:2,fillAlpha:0,  x:stage.stageWidth / 2 / 30-1, y:stage.stageHeight / 2 / 30, density:1 } );
            sim.addCircle( {lineThickness:2,lineColor:0xFFFFFF,radius:1.6,fillAlpha:0,  x:stage.stageWidth / 2 / 30+1, y:stage.stageHeight / 2 / 30, density:1 } );
            sim.mouseDrag();
            
        }
        
        private function __onEnterFrame(e:Event = null):void 
        {
            for (var body:b2Body = sim.w.m_bodyList; body ; body = body.GetNext())
            {
                if (body == center.body) continue;
                var cp:b2Vec2 =  center.body.GetPosition();
                var f:b2Vec2 = cp.Copy();
                f.Subtract(body.GetPosition());
                f.Normalize();
                f.Multiply(20);
                if(Math.random()>0.5){f = f.Negative();}
                body.ApplyForce(f, body.GetWorldCenter());
            }
        }
    }
}