/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uKur
 */

package {
  import com.actionscriptbible.Example;
  
  public class ch4ex5 extends Example {
    public function ch4ex5() {
      runCompany();
    }
    protected function runCompany():void {
      //The manager has ten employees.
      var manager:Manager = new Manager(10);
      //When you ask the manager to do work,
      var completedWork:int = manager.delegateWork();
      //You get the work of ten people.
      trace(completedWork); //10
    }
  }
}

class Employee {
  public function doWork():int {
    //Each employee does one unit of work.
    return 1;
  }
}

class Manager {
  protected var employees:Array;

  public function Manager(numberOfEmployees:int) {
    employees = new Array();
    for (var i:int = 0; i < numberOfEmployees; i++) {
      employees[i] = new Employee();
    }
  }
  public function delegateWork():int {
    var totalWork:int = 0;
    for each (var employee:Employee in employees) {
      totalWork += employee.doWork();
    }
    return totalWork;
  }
}