/**
 * Copyright samegame ( http://wonderfl.net/user/samegame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uKal
 */

/**
 * (問題点:ブロックの形状がださい)
 * 解決:drawRoundRect()でちょっとかっこよくなった。
 * 
 * 問題点:でもまだブロックがしょぼい。
 */
package
{
	import flash.display.Sprite;
	
	[SWF(backgroundColor = "0x0")]
	public class Main extends Sprite
	{
		public function Main()
		{
			var panel:Panel = new Panel();
			addChild(panel);
		}
	}
}

import flash.display.Sprite;

class Panel extends Sprite // ブロックはパネルに貼る
{
	public static const WIDTH:int = 10; 	// ブロックの数 - 横
	public static const HEIGHT:int = 10; 	// ブロックの数　- 縦
	
	private var blocks:Array;
	
	public function Panel()
	{
		createBlocks();
	}
	
	private function createBlocks():void
	{
		blocks = new Array(WIDTH);
		
		for (var y:int = 0; y < HEIGHT; y++)
		{
			blocks[y] = new Array(HEIGHT);
			
			for (var x:int = 0; x < WIDTH; x++)
			{
				var block:Block = new Block();
				block.x = x * Block.WIDTH;
				block.y = y * Block.HEIGHT;
				addChild(block);
				
				blocks[y][x] = block;
			}
		}
	}
}

class Block extends Sprite
{
	public static const WIDTH:int = 30; 	// ブロックの横幅
	public static const HEIGHT:int = 30; 	// ブロックの縦幅
	
	public static const CW:int = 2;			// 補正幅 - ブロック同士がくっつかないように
	public static const CH:int = 2;			// 補正縦
	
	public static const RW:int = 15;		// drawRoundRect()のellipseWidth
	public static const RH:int = 15;		// drawRoundRect()のellipseHeight
	
	public function Block()
	{	
		graphics.beginFill(Color.COLORS[int(Math.random() * Color.COLORS.length)]); // ランダムで色を選ぶ
		graphics.drawRoundRect(CW, CH, WIDTH - CW, HEIGHT - CH, RW, RH);
		graphics.endFill();
	}
}

// ブロックの色を保持している
class Color
{
	public static const COLORS:Array = [0xED1A3D, 0x00B16B, 0x007DC5];
}