/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uKaU
 */

package 
{
    import flash.system.LoaderContext;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    /**
     * @author Jacky Riawan
     * not sure how to upload image in wonderfl :/
     */
    public class Main extends Sprite 

    {
        public function Main():void 
        {
            var loader:Loader = new Loader();
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/d/dd/ddfc/ddfc9dfddcc98a245bf8c581bdf6d0299ead66de"),new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
        }
        private function completeHandler(e:Event):void 
        {
            var sourceBitmap:BitmapData = (e.target.content).bitmapData;
            var bitmapData:BitmapData = new BitmapData(sourceBitmap.width, sourceBitmap.height,false);
            var depth:Vector.<int> = Vector.<int>([2, 4, 8, 16, 32, 64]);
            var w_limit:int = bitmapData.width / depth.length;
            bitmapData.lock();
            for (var i:int = 0; i < depth.length; i++) {
                var limit:int = w_limit;
                var current_depth:int = depth[i];
                var divider:int = 255 / (current_depth);
                   for (var _x:int = 0; _x < w_limit; _x++) {
                    for (var _y:int = 0; _y < bitmapData.height; _y++) {
                        if (_x == w_limit-1) {
                            bitmapData.setPixel(i * w_limit + _x, _y, 0xFFFFFF);
                        }else{
                            var color:uint = sourceBitmap.getPixel(i * w_limit + _x, _y);
                            var r: int = ((color >>> 0x10) & 0xff) / divider;
                            var g: int = ((color >>> 0x08) & 0xff) / divider;
                            var b: int = (color & 0xff) / divider;
                            switch(current_depth) {
                                case 2:
                                    r = g = b = (r + g + b) / 3 * 255;
                                    break;
                                case 4:
                                    r = g = b = (r + g + b) * divider / 3;
                                    break;
                                default:
                                    r *= divider;
                                    g *= divider;
                                    b *= divider;
                                    break;
                            }                           
                            var new_color:uint = r << 16 | g << 8 | b;
                            bitmapData.setPixel(i * w_limit + _x, _y, new_color);
                        }
                    }
                }
            }
            addChild(new Bitmap(bitmapData));
        }
    }   
}