/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uKOr
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.utils.getTimer;
	import flash.display.BlendMode;
	/**
	 * ...
	 * @author Motoki Matsumoto
	 */
	public class Background1 extends Sprite
	{
		private var bd:BitmapData;
		private var fig:Shape;
		public function Background1() 
		{
			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}
		
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);

			var w:Number = 465;
			var h:Number = 465;
			
			var fig:Shape = new Shape();
			var g:Graphics = fig.graphics;
			//g.lineStyle(1, 0);
			g.beginFill(0xff0000);
			drawWave(g, 100, 30, 3, 12, 0);
			g.endFill();
			
			bd = new BitmapData(100, 30, true, 0x00000000);
			bd.draw(fig, null, null);
			bd.draw(fig, new Matrix(1,0,0,1, 0, 15), null, BlendMode.ADD);
			bd.draw(fig, new Matrix(1,0,0,1, 0, -(30-15)), null, BlendMode.ADD);
			

			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			//var t:Number = Math.sin();
			draw(getTimer()/ 1000);
		}
		
		private function draw(ty:Number):void
		{
			graphics.clear();
			graphics.beginBitmapFill(bd, new Matrix(1,0,0,1,0, 60 * ty));
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
		}
		private function drawWave(g:Graphics, w:Number, h:Number, lh:Number, cx:Number, cy:Number):void {
			var p0:Point = new Point(0,0);
			var p1:Point = new Point(0.25 * w, 0.5 * h);
			var p2:Point = new Point(0.5 * w, h);
			var p3:Point = new Point(0.75 * w, 0.5 * h);
			var p4:Point = new Point(w, 0);
			
			var p5:Point = new Point(w,lh);
			var p6:Point = new Point(w*0.5, h - lh);
			var p7:Point = new Point(0,lh);
			var c:Point = new Point(cx, cy);
			g.moveTo (p0.x, p0.y);
			g.curveTo(p0.x + c.x, p0.y + c.y, p1.x, p1.y);
			g.curveTo(p2.x - c.x, p2.y - c.y, p2.x, p2.y);
			g.curveTo(p2.x + c.x, p2.y - c.y, p3.x, p3.y);
			g.curveTo(p4.x - c.x, p4.y + c.y, p4.x, p4.y);
			
			g.lineTo(p5.x, p5.y);
			g.curveTo(p5.x - c.x, p5.y + c.y, p3.x, p3.y);
			g.curveTo(p6.x + c.x, p6.y - c.y, p6.x, p6.y);
			g.curveTo(p6.x - c.x, p6.y - c.y, p1.x, p1.y);
			g.curveTo(p7.x + c.x, p7.y + c.y, p7.x, p7.y);
			g.lineTo(p0.x, p0.y);
		}
		
	}
}