/**
 * Copyright gyo ( http://wonderfl.net/user/gyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uKJg
 */

// forked from hogemaruo's 雷とか放電とか。
/**
 * perlinNoiseで雷とか放電とか。
 * ボタン押下中はスロー風味になります。
 */
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.GlowFilter;
    import flash.filters.DropShadowFilter;
    import flash.display.Graphics;
    public class Thunder extends Sprite
    {
        public function Thunder() 
        {
            const NOISE_BIT:int = 7;
            const NOISE_RANGE:int = 1 << NOISE_BIT;
            const NOISE_MASK:int = NOISE_RANGE-1;
            var bmp:Bitmap = new Bitmap( new BitmapData(NOISE_RANGE, NOISE_RANGE));
            bmp.bitmapData.perlinNoise(NOISE_RANGE, NOISE_RANGE, 8, Math.floor(Math.random() * 0xffff), true, true, 4 );
            normalize( bmp.bitmapData );
            var spr:Sprite = new Sprite();
            addChild( spr );
            var f0:Array = [new GlowFilter(0xffffff, 0.5, 16, 16, 1, 1),new GlowFilter(0xffff00, 1, 8, 8, 1, 1),new DropShadowFilter(0, 90, 0xcc3300, 1, 64, 64,5,3)];
            var f1:Array = [new GlowFilter(0xffffff, 0.5, 16, 16, 1, 1),new GlowFilter(0x00ffff, 1, 8, 8, 1, 1),new DropShadowFilter(0, 90, 0x0033CC, 1, 64, 64,5,3)];
            var ry:int = 0;
            var rx:int = 0;
            var baseX:int = stage.stageWidth / 2;
            var baseY:int = 0;
            var vx:Number = 0;
            var vy:Number = 1;
            var len:Number = 256;
            var ptn:int = 0;
            spr.filters = f0;
            graphics.beginFill(0x000000);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
            stage.addEventListener( MouseEvent.MOUSE_DOWN, function( e:MouseEvent):void {
                ptn = 1;
                spr.filters = f1;
            });
            stage.addEventListener( MouseEvent.MOUSE_UP, function( e:MouseEvent):void {
                ptn = 0;
                spr.filters = f0;
            });
            stage.addEventListener( MouseEvent.MOUSE_MOVE, function( e:MouseEvent):void {
                var _dx:Number = mouseX - baseX;
                var _dy:Number = mouseY - baseY;
                var _len:Number = Math.sqrt(_dx * _dx + _dy * _dy);
                if ( _len != 0 ) {
                    len = _len;
                    vx = _dx / len;
                    vy = _dy / len;
                }
            });
            stage.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                if ( ptn == 0){
                    rx += Math.floor(Math.random() * 4);
                    ry = Math.floor(Math.random() * NOISE_RANGE);
                }else {
                    rx++;
                    ry+=2;
                }
                rx &= NOISE_MASK;
                ry &= NOISE_MASK;
                var colBase:int = bmp.bitmapData.getPixel(rx, ry) & 0xff;
                spr.graphics.clear();
                spr.graphics.lineStyle(Math.floor(Math.random() * 4) + 1, 0xffffff);
                var _x:Number = baseX;
                var _y:Number = baseY;
                spr.graphics.moveTo(_x, _y);
                for ( var i:int = 1; i < NOISE_RANGE; i++ ) {
                    var c:int = ( bmp.bitmapData.getPixel((rx+i) & NOISE_MASK, ry) & 0xff ) -colBase;
                    spr.graphics.lineTo(_x+c*vy, _y +c*-vx);
                    _x += vx * len / NOISE_RANGE;
                    _y += vy * len / NOISE_RANGE;
                }
            });
        }
        private function normalize( data:BitmapData, range:int = 255 ):void {
            var min:int = 255;
            var max:int = 0;
            for ( var i:int = 0; i < data.height; i++ ) {
                for ( var j:int = 0; j < data.width; j++ ) {
                    var col:int = data.getPixel(j, i);
                    if ( col < min ) min = col;
                    if ( col > max ) max = col;
                }
            }
            if( max == 0 )return;
            for ( i = 0; i < data.height; i++ ) {
                for ( j = 0; j < data.width; j++ ) {
                    col = ( data.getPixel(j, i) & 0xff ) - min;
                    col = col * range / max;
                    data.setPixel( j, i, col );
                }
            }
        }
    }
}