/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uK23
 */

//とりあえずメモ
package 
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	/**
	 * ...
	 * @author umhr
	 */
	[SWF(backgroundColor="#F9F9F9")]
	public class  Main extends Sprite
	{
		public function Main() {
			
			var menu:SlideMenu = new SlideMenu();
			menu.x = 35;
			menu.y = 200;
			menu.onChange = onChange;
			menu.onComp = onComp;
			addChild(menu);
			
			//左右移動
			var arrowL:Sprite = new Sprite();
			arrowL.graphics.beginFill(0x333333)
			arrowL.graphics.drawRect(0, 0, 32, 65);
			arrowL.graphics.endFill();
			arrowL.x = 0;
			arrowL.y = menu.y+1;
			arrowL.name = String(1);
			arrowL.addEventListener(MouseEvent.CLICK, onClickArrow);
			this.addChild(arrowL);
			
			var arrowR:Sprite = new Sprite();
			arrowR.graphics.beginFill(0x333333)
			arrowR.graphics.drawRect(0, 0, 32, 65);
			arrowR.graphics.endFill();
			arrowR.x = 465-32;
			arrowR.y = menu.y+1;
			arrowR.name = String(-1);
			arrowR.addEventListener(MouseEvent.CLICK, onClickArrow);
			this.addChild(arrowR);
			
			//左右移動スプライトをクリックすると、menuのselect値を加算または減算する。
			function onClickArrow(e:MouseEvent):void {
				menu.select = menu.select + int(e.target.name);
			}
			
			//ステイタス表示用
			var statusTF:TextField = new TextField();
			addChild(statusTF);
			function onChange(n:int):void{
				statusTF.text = "onChange"+n;
			}
			function onComp(n:int):void{
				statusTF.text = "onComp"+n;
			}
		}
	}
}


import flash.display.Sprite;
import caurina.transitions.Tweener;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
class SlideMenu extends Sprite 
{
	private var _imgRect:Rectangle = new Rectangle(4,0,96,63);
	private var _icon_array:Array;
	private var _dammy:Object;
	private var _select:int = 10000;
	public function SlideMenu() {
		//背景
		graphics.beginFill(0x666666)
		graphics.drawRect(-35, 0, 465, 67);
		graphics.endFill();
		//値管理用
		_dammy = {x:0};
		_dammy.x = _select * (_imgRect.x + _imgRect.width);
		//iconを配列にいれておく
		_icon_array = [];
		var colors:Array = [0xFF0000, 0x00FF00, 0x0000FF, 0xFFFF00];
		for (var i:int = 0; i < 8; i++) {
			var sp:Sprite = new Sprite();
			sp.graphics.beginFill(colors[i%colors.length]);
			sp.graphics.drawRect(0, 0, _imgRect.width, _imgRect.height);
			sp.graphics.endFill();
			sp.name = String(i);
			sp.addEventListener(MouseEvent.CLICK, onClick);
			sp.y = 2;
			this.addChild(sp);
			_icon_array[i] = sp;
		}
		//初期化
		select = _select;
	};
	public var onChange:Function = function(n:int):void{};
	public var onComp:Function = function(n:int):void{};
	//
	private function onClick(e:MouseEvent):void {
		select = select - (((int(e.target.name) + select) % 8 + 2) % 8 - 2);
	}
	//選択した値をset&get
	public function set select(num:int):void {
		_select = num;
		onChange(num%4);
		Tweener.addTween(_dammy, { x:(_imgRect.x + _imgRect.width)*num, time:1, onUpdate:_onUpdate,onComplete:onComp,onCompleteParams:[num%4]} );
		function _onUpdate():void {
			setPosition(_dammy.x);
		}
	}
	public function get select():int {
		return _select;
	}
	//dammyの値に対して、icon達の座標を決定
	private function setPosition(pozX:Number):void {
		var imgWX:int = _imgRect.x + _imgRect.width;
		_icon_array[0].x = (pozX + imgWX*10) % (imgWX*8) - imgWX*2;
		_icon_array[1].x = (pozX + imgWX*11) % (imgWX*8) - imgWX*2;
		_icon_array[2].x = (pozX + imgWX*12) % (imgWX*8) - imgWX*2;
		_icon_array[3].x = (pozX + imgWX*13) % (imgWX*8) - imgWX*2;
		_icon_array[4].x = (pozX + imgWX*14) % (imgWX*8) - imgWX*2;
		_icon_array[5].x = (pozX + imgWX*15) % (imgWX*8) - imgWX*2;
		_icon_array[6].x = (pozX + imgWX*16) % (imgWX*8) - imgWX*2;
		_icon_array[7].x = (pozX + imgWX*17) % (imgWX*8) - imgWX*2;
	}
}
