/**
 * Copyright nishink ( http://wonderfl.net/user/nishink )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uIIn
 */

//
// ！！！！　音　量　注　意　！！！！
//
// いきなり音が出ます。音量は小さめでお願いします。
// 
package {
	import flash.display.Sprite;
	import flash.media.Sound;
	import flash.events.SampleDataEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	public class FlashTest extends Sprite {
		private var volume:Number = 0.125;
		private var sound:Sound = new Sound();
		public function FlashTest() {
			// 注意書き
			var tf:TextField = new TextField();
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.htmlText = "<font size='128'>音量\n注意</font>\nいきなり音が出ます。音量は小さめでお願いします。";
			addChild(tf);
			// SampleDataEventはFlash Playerが次に鳴らす音を要求するときに呼び出されます。
			// そのときに、波形データを渡してやるとその音が鳴ります。
			// MP3などを鳴らす場合はファイルから読み込んだデータを渡しますが、
			// 今回は波形データをその場で作って渡します。
			sound.addEventListener(SampleDataEvent.SAMPLE_DATA,squareWave);
			sound.play();
		}
		// 正弦波：やわらかい笛のような音が出ます
		private function sineWave(ev:SampleDataEvent):void {
			var data:Number;
			for (var i:int=0; i<8192; i++) {
				data = Math.sin(
					Number(i + ev.position) / Math.PI / 2
				) * volume;
				ev.data.writeFloat(data);
				ev.data.writeFloat(data);
			}
		}
		// のこぎり波：音の強いラッパみたいな音が出ます
		private function sawWave(ev:SampleDataEvent):void {
			var data:Number;
			for (var i:int=0; i<8192; i++) {
				data = (
					1.0 / 128.0 * (i % 256 - 128)
				) * volume;
				ev.data.writeFloat(data);
			}
		}
		// 矩形波：おなじみファミコンみたいなピコピコ音が出ます
		private function squareWave(ev:SampleDataEvent):void {
			var data:Number;
			for (var i:int=0; i<16384; i++) {
				if (i % 256 < 128) {
					data = 1.0 * volume;
				} else {
					data = -1.0 * volume;
				}
				// writeFloatを4096～16384回呼ばないと音が出ない
				// 呼ぶ回数が多いほど高音質らしい
				ev.data.writeFloat(data);
			}
		}
	}
}

