/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uI2k
 */

package 
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    
    /**
     * ...
     * @author rettuce
     * 
     */
    public class Main extends Sprite
    {
        private var _ball:Ball;
        private var _targetX:Number;
        private var _targetY:Number;
        private var _spring:Number = 0.2;    // バネ係数
        private var _easing:Number = 0.1;
        private var _vx:Number = 0;            // 速度
        private var _vy:Number = 0;            // 速度
        private var _friction:Number = 0.95;    // 摩擦係数
        
        private var NUM:int = 60;
        private var pointArr:Array = [];
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }
        
        private function init(e:Event = null ):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();

            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void {
                removeEventListener(Event.ENTER_FRAME, enterframeHandler);
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
            
            _ball = new Ball(50, 0xFFFFFF*Math.random());
            addEventListener(Event.ENTER_FRAME, enterframeHandler)
        }
        
        private function enterframeHandler(e:Event):void
        {
            _targetX = mouseX;
            _targetY = mouseY;
            
            if(pointArr.length >= NUM) pointArr.shift();            
            pointArr.push(new Point(_ball.x, _ball.y));
            
            graphics.clear();
            graphics.moveTo(pointArr[0].x, pointArr[0].y);
            
            for(var i:int=0; i<pointArr.length-1; i++){
                var px:Number = (pointArr[i].x + pointArr[i+1].x)/2;
                var py:Number = (pointArr[i].y + pointArr[i+1].y)/2;                
                graphics.curveTo(pointArr[i].x, pointArr[i].y, px, py);
                graphics.lineStyle(30*Math.random(), 0xFFFFFF*Math.random(), Math.random());
            }
    
            var dx:Number = _targetX - _ball.x;    //ゴール地点までの距離
            var dy:Number = _targetY - _ball.y;
            var ax:Number = dx*_spring;            //距離xバネ係数=加速度
            var ay:Number = dy*_spring;
            _vx += ax;                            //現速度に加速度を加算
            _vy += ay;
            _vx *= _friction;                    //速度に摩擦係数を乗算        
            _vy *= _friction;            
            _ball.x += _vx;
            _ball.y += _vy;
        }
        
        /********* stage set ************/
        private function setStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void {
            resizeHandler();
        }        
        public function resizeHandler():void {            
        }        
    }
}

import flash.display.Sprite;    
class Ball extends Sprite
{
    private var _radius:Number;
    private var _color:Number;
    public var _vx:Number;
    public var _vy:Number;
    
    public function Ball(radius:Number = 40, color:Number = 0xFF0000)
    {
        _radius = radius;
        _color = color;
        init();
    }
    
    public function init():void
    {
        graphics.beginFill(_color);
        graphics.drawCircle(0,0,_radius);
        graphics.endFill();
    }
}
