/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uHdN
 */

// forked from aobyrne's forked from: Draw circle by Quadratic Bezier curve
// forked from kenz's Draw circle by Quadratic Bezier curve
package
{    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
     import flash.geom.Point;
  
    import net.hires.debug.Stats;
    
        [SWF( width="465", height="465", backgroundColor="0xffffff", frameRate="30" )]
    
    import flash.display.Graphics;
    public class DrawBezierCircle extends Sprite
    {
            // ポイントの数
            private const POINT_NUMBER:uint = 8;
            
            // 円の半径
            private const RADIUS:uint = 150;
            
            // 中心点
            private var _centerX:uint, _centerY:uint;
            
            // radian
            private var _radian:Number;
            
            private var _list:Array;
            
            // canvas
        private var _apCanvas:Sprite;
        private var _cpCanvas:Sprite;
        private var _lineCanvas:Sprite;
        private var bmd:BitmapData;
        private var bm:Bitmap;
        private var bf:BlurFilter;
            
        public function DrawBezierCircle()
        {
                bm = new Bitmap();
                bmd = new BitmapData(stage.stageWidth,stage.stageHeight,true,0x00ff0000);
                bm.bitmapData = bmd;
                addChildAt(bm,0);        
               _centerX = stage.stageWidth >> 1;
                _centerY = stage.stageHeight >> 1;
                
                _list = [];
                _radian = 2 * Math.PI / POINT_NUMBER;
                
                // 円の中心からコントロールポイントまでの距離
                var _rc:Number;
                
                // コントロールポイントn とコントロールポイントn+1 の間の角度
                var _d:Number;
                
                var _cp:p;
                for ( var i:int = 0; i < POINT_NUMBER; i++ )
                {
                    _d = ( _radian * ( i + 1 ) ) - ( _radian * i );
                    _rc = RADIUS / Math.cos( _d * .5 );
                    _cp = new p(
                     _centerX + _rc * Math.cos( _radian * ( i + 1 ) - _d * .5 ),
                     _centerY + _rc * Math.sin( _radian * ( i + 1 ) - _d * .5 ) 
                     );
                    _list.push( _cp );
                }
                
            _apCanvas = new Sprite();
            _cpCanvas = new Sprite();
            _lineCanvas = new Sprite();
            
            addChild( _lineCanvas );
            addChild( _apCanvas );
            addChild( _cpCanvas );
                
                addEventListener( Event.ENTER_FRAME, loop, false, 0, true );
               // loop(null);
                addChild( new Stats() )
              bf = new BlurFilter(2,2, 1); 
            }
        private function doTrack():void
        {
            bmd.draw(_cpCanvas);
            bmd.draw(_apCanvas);
            //bmd.applyFilter(bmd, bmd.rect, new Point(0,0), bf);
            //bmd.applyFilter(bmd, bmd.rect, new Point(0,0), cmf);
            //bmd.scroll(0, 5);
            
        }
            
            private function loop( e:Event ):void
            {
                // コントロールポイント
                var _cp:p;
                var _np:p;
                
                graphics.clear();
                graphics.lineStyle(3,0xff);
                //graphics.beginFill( 0x0000ff, 1 );
                graphics.moveTo( ( _list[0].x + _list[1].x ) * .5, ( _list[0].y + _list[1].y ) * .5 );
                
            _apCanvas.graphics.clear();
            _apCanvas.graphics.lineStyle( 1, 0xff3300 );
            _cpCanvas.graphics.clear();
            _cpCanvas.graphics.beginFill( 0, 1 );
            _lineCanvas.graphics.clear();
            _lineCanvas.graphics.lineStyle( 1, 0x666666 );
            
                
                var i:int = POINT_NUMBER;
                while ( --i >= 0 )
                {
                    _cp = _list[i];
                    
                    _cp._radX = _cp._ax * Math.PI / 180;
                    _cp._radY = _cp._ay * Math.PI / 180;
                    
                _cp.x = _cp._cx + _cp._rx * Math.sin( _cp._radX );
                _cp.y = _cp._cy + _cp._ry * Math.sin( _cp._radY );
                _cp._ax += _cp._sx;
                _cp._ax %= 360;
                _cp._ay += _cp._sy
                _cp._ay %= 360;
                
                _np = _list[ ( i + 1 ) % ( _list.length ) ];
                
                graphics.curveTo( _np.x, _np.y, ( _cp.x + _np.x ) * .5, ( _cp.y + _np.y ) *.5 );
                
                _apCanvas.graphics.drawCircle( ( _cp.x + _np.x ) * .5, ( _cp.y + _np.y ) * .5, 1 );
                _cpCanvas.graphics.drawCircle( _np.x, _np.y, 1 );
                _lineCanvas.graphics.moveTo( _cp.x, _cp.y );
                _lineCanvas.graphics.lineTo( _np.x, _np.y );
                
                }
            
            //graphics.endFill();
            
            _apCanvas.graphics.endFill();
            _cpCanvas.graphics.endFill();
            _lineCanvas.graphics.endFill();
            
            doTrack();
            }
    }
}


import flash.geom.Point;

class p extends Point
{
    public var _cx:Number, _cy:Number;
    public var _radX:Number, _radY:Number;
    public var _rx:Number, _ry:Number;
    public var _ax:Number, _ay:Number;
    public var _sx:Number, _sy:Number;
    
    public function p( x:Number, y:Number )
    {
        this.x = _cx = x;
        this.y = _cy = y;
        _rx = ( Math.random() * 40 | 0 ) - 20;
        _ry = ( Math.random() * 40 | 0 ) - 20;
        _ax = _ay = 0;
        _sx = Number( ( Math.random() * 4 + 1 ).toFixed(1) );
        _sy = Number( ( Math.random() * 4 + 1 ).toFixed(1) );
    }
}