/**
 * Copyright nash ( http://wonderfl.net/user/nash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uHKK
 */

package {
    import flash.display.SimpleButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.ui.Keyboard;
    import flash.utils.Timer;
    import flash.utils.escapeMultiByte;
    
    [SWF(width="465",height="465")]
    
    public class FlashTest extends Sprite {
        private var walls:Vector.<Sprite> = new Vector.<Sprite>();
        private var frames:int = 0;
        private var wall:Sprite;
        private var player:Sprite;
        private var texts:Vector.<TextField> = new Vector.<TextField>();
        private var score:TextField;
        private var scoreLabel:TextField;
        private var rect:Sprite;
        private var flag:Boolean = true;
        
        public function FlashTest() {
            transform.perspectiveProjection.projectionCenter = new Point(stage.stageWidth / 2, stage.stageHeight);
            player = new Sprite();
            player.graphics.beginFill(0xCCCC);
            player.graphics.drawCircle(0, 0, 30);
            player.graphics.endFill();
            player.y = 465
            player.z = 0;
            player.alpha = 0.8;
            addChild(player);
            
            score = new TextField();
            score.selectable = false;
            score.text = "0";
            score.x = 465 - score.textWidth - 10;
            score.y = 0;
            addChild(score);
            
            scoreLabel = new TextField();
            scoreLabel.selectable = false;
            scoreLabel.text = "Score : ";
            scoreLabel.x = 465 - score.textWidth - 10 - scoreLabel.textWidth - 10;
            scoreLabel.y = 0;
            addChild(scoreLabel);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            if (player.x < 0 || player.x > 465) {
                return;
            }
            
            if (e.keyCode == Keyboard.LEFT) {
                player.x -= 10;
                if (player.x < 0) {
                    player.x = 1;
                }
            } else if (e.keyCode == Keyboard.RIGHT) {
                player.x += 10;
                if (player.x > 465) {
                    player.x = 464;
                }
            }
        }
        
        private function onMouseMove(e:MouseEvent = null):void {
            player.x = stage.mouseX;
        }
        
        private function onEnterFrame(e:Event = null):void {
            frames++;
            
            score.text = (frames + 10).toString(10);
            score.x = 465 - score.textWidth - 10;
            scoreLabel.x = 465 - score.textWidth - 10 - scoreLabel.textWidth - 10;
            
            var tf:TextField = new TextField();
            tf.selectable = false;
            tf.defaultTextFormat = new TextFormat(null, 100, 0xFFFFFF);
            
            if (frames % 30 == 0) {
                var color:uint = int.MAX_VALUE * Math.random();
                flag = !flag;
                
                wall = new Sprite();
                wall.graphics.beginFill(color);
                wall.graphics.drawRect(0, 0, 150, 150);
                wall.graphics.endFill();
                wall.x = flag ? Math.random() * 232 + 233 : Math.random() * 232;
                wall.y = 465 - wall.height;
                wall.z = 3000;
                wall.alpha = 0.8;
                walls.push(wall);
                addChild(wall);
                
                tf.textColor = ~color;
                tf.text = wall.z.toString(10);
                tf.x = wall.x;
                tf.y = wall.y;
                tf.z = wall.z;
                tf.alpha = 0.8;
                addChild(tf);
                texts.push(tf);
            }

            for (var i:int=walls.length-1; i>-1; i--) {
                walls[i].z -= Math.random() * 10;
                texts[i].text = walls[i].z.toString(10);
                texts[i].x = walls[i].x;
                texts[i].y = walls[i].y;
                texts[i].z = walls[i].z;
                
                addChild(walls[i]);
                addChild(texts[i]);
                
                if (walls[i].z < 0) {
                    if (walls[i].x < (player.x + player.width / 2) && walls[i].x + walls[i].width > (player.x - player.width / 2)) {
                        removeEventListener(Event.ENTER_FRAME, onEnterFrame);
                        onEnd();
                    }                    

                    removeChild(walls[i]);
                    removeChild(texts[i]);
                    texts.splice(i, 1);
                    walls.splice(i++, 1);
                }
            }
            addChild(player);
        }
        
        private function onEnd():void {
            var timer:Timer = new Timer(10, 100);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            
            timer.addEventListener(TimerEvent.TIMER, function():void {
                for (var i:int=0; i<walls.length; i++) {
                    walls[i].alpha -= 0.008;
                    texts[i].alpha -= 0.008;
                }
                
                player.alpha -= 0.008;
            });
            
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, function():void {
                for (var i:int=0; i<walls.length; i++) {
                    removeChild(walls[i]);
                    removeChild(texts[i]);
                    walls.splice(i, 1);
                    texts.splice(i--, 1);
                }
                
                removeChild(player);

                rect = new Sprite();
                rect.graphics.beginFill(0x000000);
                rect.graphics.drawRect(0, 100, 465, 265);
                rect.graphics.endFill();
                rect.alpha = 0.0;
                addChild(rect);
                
                var timer2:Timer = new Timer(10, 100);
                
                timer2.addEventListener(TimerEvent.TIMER, function():void {
                    rect.alpha += 0.008;
                });
                
                timer2.addEventListener(TimerEvent.TIMER_COMPLETE, function():void {
                    rect.alpha = 0.8;
                    var tf:TextField = new TextField();
                    tf.defaultTextFormat = new TextFormat(null, null, 0xFFFFFF);
                    tf.selectable = false;
                    tf.text = "ゲーム終了！\nスコア：" + score.text;
                    tf.x = stage.stageWidth / 2 - tf.textWidth / 2;
                    tf.y = stage.stageHeight / 2 - tf.textHeight / 2;
                    addChild(tf);

                    var upState:Button = new Button(0x00CCCC);
                    var overState:Button = new Button(0xFF4500);
                    
                    var twb:SimpleButton = new SimpleButton(upState, overState, overState, overState);
                    twb.addEventListener(MouseEvent.CLICK, function():void {
                        navigateToURL(new URLRequest("http://twitter.com/intent/tweet?status=" + escapeMultiByte("Z-AXISでスコア" + score.text + "を記録しました！ #z_axis")));
                    });
                    
                    addChild(twb);
                    
                    removeChild(score);
                    removeChild(scoreLabel);
                });
                
                timer2.start();
                
            });
            
            timer.start();
        }
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

class Button extends Sprite{
    public function Button(color:uint) {
        graphics.lineStyle(2.0, color);
        graphics.beginFill(0xFFFFFF);
        graphics.drawRect(300, 300, 100, 30);
        graphics.endFill();
        
        var btnLabel:TextField = new TextField();
        btnLabel.selectable = false;
        btnLabel.text = "Twitterに投稿する";
        btnLabel.x = 350 - btnLabel.textWidth / 2;
        btnLabel.y = 315 - btnLabel.textHeight / 2;
        
        addChild(btnLabel);
    }
}