/**
 * Copyright ile ( http://wonderfl.net/user/ile )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uH9x
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.Security;

    public class Main extends Sprite {
        private const WIDTH:Number = 35;
        private const HEIGHT:Number = 35;
        private var yPanel:uint = 10;
        private var xPanel:uint = 10;
        private var yobiPanel:uint = 5;
        private var baseX:Number = 0;
        private var baseY:Number = 0;
        private var loopFlg:int = 0;
        
        private var swfLoader:Loader;    
        private var gameBoard:Array = new Array();
        private var panelClsArr:Array = new Array();
        
        public function Main() {
            loadPanel();
        }
        
        private function loadPanel():void{
            var url:String = "http://ile.jp/wp-content/uploads/2011/11/panel.swf";
            var urlReq:URLRequest;
            
            Security.allowDomain("*");
            swfLoader = new Loader();
            urlReq = new URLRequest(url);
            swfLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, setPanels);
            swfLoader.load(urlReq);
        }
        private function setPanels(event:Event):void{
            panelClsArr[0] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelKL_mc") as Class;
            panelClsArr[1] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelMS_mc") as Class;
            panelClsArr[2] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelMU_mc") as Class;
            panelClsArr[3] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelYK_mc") as Class;
            panelClsArr[4] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelHS_mc") as Class;
            panelClsArr[5] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelHU_mc") as Class;
            panelClsArr[6] = swfLoader.contentLoaderInfo.applicationDomain.getDefinition("panelTT_mc") as Class;
            for(var i:uint = 0; i < yPanel; i++){
                gameBoard[i] = new Array();
                for (var j:uint = 0; j < xPanel; j++){
                    loopFlg = 0;
                    var r:uint = Math.floor(Math.random() * 6) + 1;
                    var panel:PanelMaker = new PanelMaker(panelClsArr, WIDTH * j+baseX, HEIGHT * i+baseY, r,1, i,j);
                    addChild(panel);
                    gameBoard[i][j] = panel;
                }
                trace(gameBoard[i][0].panelType+" "+gameBoard[i][1].panelType+" "+gameBoard[i][2].panelType+" "+gameBoard[i][3].panelType+" "+gameBoard[i][4].panelType+" "+gameBoard[i][5].panelType+" "+gameBoard[i][6].panelType+" "+gameBoard[i][7].panelType+" "+gameBoard[i][8].panelType+" "+gameBoard[i][9].panelType);
            }
        }
        
    }
}


import flash.display.MovieClip;

class PanelMaker extends MovieClip {
    private var _panelType:uint;
    private var _tate:uint;
    private var _yoko:uint;
    private var _frame:uint;
    private var testCls:Class;
    private var panelMcArr:Array = new Array();
    
    public function PanelMaker(panelClsArr:Array, x:Number, y:Number, panelType:uint, frame:uint , tate:int, yoko:int):void
    {
        this.x = x;
        this.y = y;
        _panelType = panelType;
        _frame = frame;
        _tate = tate;
        _yoko = yoko;
        for(var i:uint=0;i<7;i++) panelMcArr[i]= new panelClsArr[i]();
        addChild(panelMcArr[_panelType]);
        panelMcArr[_panelType].gotoAndStop(_frame);
    }
    public function get tate():int
    {
         return _tate;
    }
    public function set tate(v:int):void
    {
         _tate = v;
    }
    public function get yoko():int
    {
         return _yoko;
    }
    public function set yoko(v:int):void
    {
         _yoko = v;
    }
    public function get panelType():uint
    {
         return _panelType;
    }
    public function set panelType(v:uint):void
    {
         removeChild(panelMcArr[_panelType]);
         _panelType = v;
         addChild(panelMcArr[_panelType]);
         this.panelMcArr[_panelType].gotoAndStop(1); 
    }
    public function get frame():int
    {
         return panelMcArr[_panelType].currentFrame;
    }
    public function set frame(v:int):void
    {
         panelMcArr[_panelType].gotoAndStop(v); 
    }
}

