/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uG3b
 */

package {
  import flash.display.*;
  import flash.events.Event;
  import flash.geom.*;
  public class ch39ex3 extends Sprite {
    protected var perspective:PerspectiveProjection;
    protected var viewMatrix:Matrix3D;
    protected var modelMatrix:Matrix3D;
    protected var model:Plot3D;

    protected var projectedPoints:Vector.<Number> = new Vector.<Number>();
    protected var texturePoints:Vector.<Number> = new Vector.<Number>();
    protected var drawCommands:Vector.<int>;
    public function ch39ex3() {
      stage.quality = StageQuality.MEDIUM;
      this.x = stage.stageWidth/2;
      this.y = stage.stageHeight/2;
      perspective = new PerspectiveProjection();
      perspective.fieldOfView = 50;
      perspective.projectionCenter = new Point(0, 0); 
      viewMatrix = new Matrix3D();
      viewMatrix.appendTranslation(0, 4, 11);
      viewMatrix.appendRotation(26, Vector3D.X_AXIS);
      viewMatrix.append(perspective.toMatrix3D());
      modelMatrix = new Matrix3D();
      model = new Plot3D();
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      model.tOffset-=0.2;
      model.plot(new Rectangle(-3, -3, 6, 6), 48);
//      modelMatrix.appendRotation(2, Vector3D.Y_AXIS);
      var concatenatedMatrix:Matrix3D = modelMatrix.clone();
      concatenatedMatrix.append(viewMatrix);
      Utils3D.projectVectors(
        concatenatedMatrix, model.vertices, projectedPoints, texturePoints);
      graphics.clear();
      graphics.lineStyle(0, 1, 0.5);
      graphics.beginFill(0x404040, 0.6);
      var culling:String = (stage.mouseY > stage.stageHeight/2)? TriangleCulling.NEGATIVE : TriangleCulling.NONE; 
      graphics.drawTriangles(projectedPoints, model.indices, null, culling);
    }
  }
}
import flash.geom.Rectangle;
import flash.geom.Vector3D;
class Plot3D {
  public var vertices:Vector.<Number>;
  public var indices:Vector.<int>;
  public var tOffset:Number = 0;
  public var resolution:Number;
  public function plot(xzBounds:Rectangle, resolution:Number = 200):void {
    vertices = new Vector.<Number>();
    var r:Rectangle = xzBounds;
    for (var z:Number = r.top; z < r.bottom; z += r.height/resolution) {
      for (var x:Number = r.left; x < r.right; x += r.width/resolution) {
        var y:Number = Math.sin(Math.pow(x, 2) + Math.pow(z, 2) + tOffset);
        vertices.push(x, y, z);
      } 
    }
    if (resolution != this.resolution) {
      this.resolution = resolution;
      indices = new Vector.<int>();
      for (var row:int = 0; row < resolution-1; row++) {
        for (var col:int = 0; col < resolution-1; col++) {
          var row1:int = row * resolution;
          var row2:int = row1 + resolution;
          indices.push(row1 + col, row2 + col, row2 + col + 1,
            row1 + col, row2 + col + 1, row1 + col + 1);
        } 
      }
    }
  }
}
