/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uFeJ
 */

// forked from 084's flash on 2010-3-9

// double click the stage!

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    public class Bouncing extends Sprite
    {
        public function Bouncing()
        {
            stage.doubleClickEnabled = true;
            stage.mouseChildren = false;
            stage.addEventListener(MouseEvent.DOUBLE_CLICK, addBall);
            addBall();
        }

        private function addBall(e:MouseEvent = null):void
        {
            var ball:Ball = new Ball(10 + 30 * Math.random(), 0xFFFFFF * Math.random());
            if (e) {
                ball.x = e.stageX;
                ball.y = e.stageY;
            } else {
                ball.x = stage.stageWidth / 2;
                ball.y = stage.stageHeight / 2;
            }
            addChild(ball);
        }
    }
}


import flash.display.Sprite;
import flash.events.Event;

class Ball extends Sprite
{
    private var radius:Number;
    private var vx:Number = 0;
    private var vy:Number = 0;

    private var top:Number = 0;
    private var bottom:Number;
    private var left:Number = 0;
    private var right:Number;

    public function Ball(radius:Number = 40, color:uint = 0xFF0000):void
    {
        this.radius = radius;
        vx = Math.random() * 10 - 5;
        vy = Math.random() * 10 - 5;

        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);

        addEventListener(Event.ADDED_TO_STAGE, function(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, arguments.callee);
            right = stage.stageWidth;
            bottom = stage.stageHeight;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        });
    }

    private function onEnterFrame(event:Event):void
    {
        x += vx;
        y += vy;

        if (x  + radius > right) {
            x = right - radius;
            changeColor();
            vx *= -1;
        } else if (x - radius < left) {
            x = left + radius;
            changeColor();
            vx *= -1;
        }

        if (y + radius > bottom) {
            y = bottom - radius;
            changeColor();
            vy *= -1;
        } else if (y - radius < top) {
            y = top + radius;
            changeColor();
            vy *= -1;
        }
    }

    private function changeColor():void
    {
        graphics.clear();
        graphics.beginFill(0xFFFFFF * Math.random());
        graphics.drawCircle(0, 0, radius);
    }
}