/**
 * Copyright rfkrocktk ( http://wonderfl.net/user/rfkrocktk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uFBa
 */

package {
    import flash.net.XMLSocket;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class ExceptionFormatting extends Sprite {
        
        private var textfield:TextField;
        
        public function ExceptionFormatting() {
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            
            this.textfield = new TextField();
            this.textfield.x = this.textfield.y = 10;
            this.textfield.width = stage.stageWidth - 20;
            this.textfield.height = stage.stageHeight - 20;
            this.textfield.defaultTextFormat = new TextFormat("Courier New");
            
            this.addChild(textfield);
            
            this.runtests();
        }
        
        private function runtests():void {
            output("Running Tests");
            output("----------------------------------");        
            
            var exception:Error = testA();
            
            output("\nPrinting full exception: ");
            output(exception.getStackTrace());
            
            output("\nPrinting two-line exception: ");
            output(exception.getStackTrace().split(new RegExp("\\n")).slice(0, 2).join("\n"));
        }
        
        private function testA():Error {
            return testB();
        }

        private function testB():Error {
            return testC();
        }

        private function testC():Error {
            return testD();
        }

        private function testD():Error {
            return new Error("It's like the end of the world, man!");
        }

                
        private function output(value:String):void {
            this.textfield.appendText(value + "\n");
        }

    }
}