/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uEUM
 */

package {
  import com.actionscriptbible.Example;
  import flash.system.Capabilities;
  import flash.ui.Multitouch;
  import flash.ui.MultitouchInputMode;
  public class ch23ex1 extends Example {
    protected var isMultitouch:Boolean;
    public function ch23ex1() {
      try {
        var test:Class = Multitouch; //older FP should throw error here
        trace("Multitouch capabilities on this device:");
        trace("Screen type:", Capabilities.touchscreenType);
        trace("Touch-level access?", Multitouch.supportsTouchEvents);
        trace("Gesture-level access?", Multitouch.supportsGestureEvents);
        trace("Number of touch points:", Multitouch.maxTouchPoints);
        if (Multitouch.supportsGestureEvents) {
          trace("supported gestures {");
          for each (var gestureName:String in Multitouch.supportedGestures) {
            trace("  -", gestureName);
          }
          trace("}");
        }
        //remember whether multitouch mode is on
        isMultitouch = Multitouch.maxTouchPoints > 1;
        //prefer gesture mode if available
        if (Multitouch.supportsGestureEvents) {
          Multitouch.inputMode = MultitouchInputMode.GESTURE;
        } else if (Multitouch.supportsTouchEvents) {
          Multitouch.inputMode = MultitouchInputMode.TOUCH_POINT;
        }
      } catch (error:ReferenceError) {
        trace("Sorry, but multitouch is not supported in this runtime.");
        isMultitouch = false;
      }
    }
  }
}