/**
 * Copyright albatrus ( http://wonderfl.net/user/albatrus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uDS5
 */

package {
	import flash.events.*;
	import flash.filters.*;
	import flash.utils.*;
	import org.papervision3d.core.effects.view.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.primitives.*;
	
	public class Reflect extends ReflectionView {
		private var cube:Cube;
		public function Reflect():void {
			// マテリアルを作成
			var material:FlatShadeMaterial = new FlatShadeMaterial(new PointLight3D(), 0x2288CC, 0x004466);
			var materials:MaterialsList = new MaterialsList( { all:material } );
			
			// 直方体を作成します
			cube = new Cube(materials);
			scene.addChild(cube);

			// 反射を設定
			surfaceHeight = -600; // 反射面の座標
			viewportReflection.filters = [new BlurFilter(8, 8, 3)]; // 反射面のフィルタ
			viewportReflection.alpha = 0.7; // 反射面の透明度
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		// エンターフレームイベントを登録
		private function loop(e:Event):void {
			// モーション
			cube.rotationY += 2;
			camera.y = 500 + 800 * Math.sin(getTimer() / 1000);
			
			// レンダリング
			singleRender();
		}
	}
}